VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MMedia"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit



  '-----------------------------------------------------
  '   Nom     :   MMedia.cls
  '   Auteur  :   Peter Wright, pour BGVB4 & BGVB5 &
  '              BGVB6
  '
  '   Notes   :   Classe multimdia qui, lorsqu'elle est
  '           :   transforme en objet vous permet de charger
  '           :   et d'utiliser des fichiers multimdias,
  '           :   tel que du son et de la vido.
  '-----------------------------------------------------

  ' -=-=-=- PROPRIETES -=-=-=-
  ' Filename      Dtermine le nom du fichier courant
  ' Length        Longueur du fichier (lecture seule)
  ' Position      Position courante dans le fichier
  ' Status        Statut courant de l'objet (lecture seule)
  ' Wait          Vrai/Faux...indique  VB d'attendre jusqu'
                  'ce que le fichier soit lu

  ' -=-=-=- METHODES -=-=-=-=-
  ' mmOuvrir <Filename>   Ouvre le fichier choisi
  ' mmFermer                Ferme le fichier courant
  ' mmPause                 Fait une pause dans la lecture du fichier courant
  ' mmArrter             Arrte la lecture et prpare  la fermeture
  ' mmChercher <Position> Cherche une position dans le fichier
  ' mmLire                  Lit le fichier ouvert

  '-------------------------------------------------------------
  ' NOTES
  ' -----

  ' Ouvrez un fichier, puis lancez-le. Mettez-le sur pause en rponse
  '  une requte de l'utilisateur.
  ' Arrtez-le si vous voulez retourner au dbut et lisez-le  nouveau.
  ' Fermez le fichier quand vous ne voulez plus le lire.
  '--------------------------------------------------------------

Private sPseudonyme As String        ' Utilis en interne pour donner un pseudonyme
                            '  la ressource multimdia
Private sNomDeFichier As String     ' Conserve le nom de fichier en interne
Private nLongueur As Single       ' Conserve la longueur du nom du fichier en
                                ' interne
Private nPosition As Single     ' Conserve la position courante en interne
Private sStatut As String       ' Conserve le statut courant en tant que chane
Private bAttendre As Boolean        ' Dtermine si VB doit attendre jusqu' ce que
                            '  l'excution soit termine avant de renvoyer

  '------------ DECLARATIONS API -------------
  'NB. Ce qui suit constitue une seule ligne de code:
Private Declare Function mciSendString Lib "winmm.dll" _
   Alias "mciSendStringA" (ByVal lpstrCommand As String, _
   ByVal lpstrReturnString As String, ByVal uReturnLongueur As Long, _
   ByVal hWndCallback As Long) As Long

Public Sub mmOuvrir(ByVal sTheFile As String)

    ' Dclare une variable qui contiendra la valeur renvoye par mciSendString
    Dim nRenvoyer As Long
    
    ' Dclare une variable de chane qui contiendra le type de fichier
    Dim sType As String

    ' Ouvre le fichier multimdia choisi et ferme tout autre fichier qui
    ' pourrait tre ouvert
    If sPseudonyme <> "" Then
        mmFermer
    End If
    
    ' Dtermine de quel type est le fichier  partir de son extension
    Select Case UCase$(Right$(sTheFile, 3))
       Case "WAV"
          sType = "Waveaudio"
       Case "AVI"
          sType = "AviVideo"
       Case "MID"
          sType = "Sequencer"
       Case Else
          ' Si l'extension de fichier n'est pas reconnue, terminer la procdure
          Exit Sub
    End Select
    sPseudonyme = Right$(sTheFile, 3) & Minute(Now)

   '  ce stade aucun fichier n'est ouvert, mais nous avons dtermin
   ' le type du fichier. Nous pouvons  prsent l'ouvrir.
   ' Note: Si le nom contient un espace, il doit figurer entre 'guillemets'
   If InStr(sTheFile, " ") Then sTheFile = Chr(34) & sTheFile & Chr(34)
   nRenvoyer = mciSendString("Open " & sTheFile & " ALIAS " & sPseudonyme _
            & " TYPE " & sType & " Wait", "", 0, 0)
End Sub

Public Sub mmFermer()
    ' Ferme le fichier multimdia

    ' Dclare une variable qui contiendra la valeur renvoye par
    ' la commande mciSendString
    Dim nRenvoyer As Long

    ' Si aucun fichier n'est ouvert, termine la procdure
    If sPseudonyme = "" Then Exit Sub
    
    nRenvoyer = mciSendString("Close " & sPseudonyme, "", 0, 0)
    sPseudonyme = ""
    sNomDeFichier = ""
    
End Sub

Public Sub mmPause()
    ' Fait une pause dans la lecture du fichier

    ' Dclare une variable qui contiendra la valeur renvoye par
    ' la commmande mciSendString
    Dim nRenvoyer As Long
    
    ' Si aucun fichier n'est ouvert, termine la procdure
    If sPseudonyme = "" Then Exit Sub
    
    nRenvoyer = mciSendString("Pause " & sPseudonyme, "", 0, 0)

End Sub

Public Sub mmLire()
    ' Excute le fichier ouvert,  partir de la position courante

    ' Dclare une variable qui contiendra la valeur renvoye par
    ' la commande mciSendString
    Dim nRenvoyer As Long
    
    ' Si aucun fichier n'est ouvert, termine la procdure
    If sPseudonyme = "" Then Exit Sub
    
    ' Excute le fichier
    If bAttendre Then
        nRenvoyer = mciSendString("Play " & sPseudonyme & " wait", "", 0, 0)
    Else
        nRenvoyer = mciSendString("Play " & sPseudonyme, "", 0, 0)
    End If
End Sub

Public Sub mmArrter()
    ' Arrte d'utiliser un fichier, qu'il soit en cours de lecture
    ' ou autre

    ' Dclare une variable qui contiendra la valeur renvoye par mciSendString
    Dim nRenvoyer As Long
    
    ' Si aucun fichier n'est ouvert, termine la procdure
    If sPseudonyme = "" Then Exit Sub
    
    nRenvoyer = mciSendString("Stop " & sPseudonyme, "", 0, 0)
    
End Sub

Public Sub mmChercher(ByVal nPosition As Single)
    ' Cherche une position spcifique dans le fichier

    ' Dclare une variable qui contiendra la valeur renvoye par
    ' la fonction mciSendString
    Dim nRenvoyer As Long
    
    nRenvoyer = mciSendString("Seek " & sPseudonyme & " to " & nPosition, "", 0, 0)

End Sub

Property Get Filename() As String
    ' Routine qui renvoie une valeur quand le programmeur demande l'objet
    ' contenant la valeur de sa proprit Filename
    Filename = sNomDeFichier
End Property

Property Let Filename(ByVal sTheFile As String)
    ' Routine qui dfinit la valeur de la proprit filename, si le
    ' programmeur le dcide. Ceci implique que le programmeur veuille
    ' ouvrir un fichier, auquel cas le contrle passe vers la routine mmOuvrir
   mmOuvrir sTheFile
End Property

Property Get Wait() As Boolean
' Routine qui renvoie la valeur de la proprit wait de l'objet
   Wait = bAttendre
End Property

Property Let Wait(bAttendreValue As Boolean)
' Routine qui dfinit la valeur de la proprit wait de l'objet
   bAttendre = bAttendreValue
End Property

Property Get Length() As Single
    ' Routine qui renvoie la longueur du fichier multimdia ouvert

    ' Dclare une variable qui contiendra la valeur renvoye
    ' par mciSendString
   Dim nRenvoyer As Long, nLongueur As Integer

    ' Dclare une chane qui contiendra la longueur renvoye par
    ' l'appel de statut MCI
   Dim sLongueur As String * 255
    
    ' S'il n'y a aucun fichier ouvert, renvoie 0
   If sPseudonyme = "" Then
      Length = 0
      Exit Property
   End If

   nRenvoyer = mciSendString("Status " & sPseudonyme & " length", sLongueur, 255, 0)
  nLongueur = InStr(sLongueur, Chr$(0))
  Length = Val(Left$(sLongueur, nLongueur - 1))
End Property

Property Let Position(ByVal nPosition As Single)
    ' Dfinit la proprit Position en cherchant
   mmChercher nPosition
End Property

Property Get Position() As Single
    ' Renvoie la position courante dans le fichier
    
    ' Dclare une variable qui contiendra la valeur renvoye par mciSendString
   Dim nRenvoyer As Integer, nLongueur As Integer
    
    ' Dclare une variable qui contiendra la position renvoye
    ' par la commande mci Status position
   Dim sPosition As String * 255

    ' Si aucun fichier n'est ouvert, ferme la procdure
   If sPseudonyme = "" Then Exit Property
    
    ' Trouve la position et la renvoie
   nRenvoyer = mciSendString("Status " & sPseudonyme & " position", sPosition, 255, 0)
   nLongueur = InStr(sPosition, Chr$(0))
   Position = Val(Left$(sPosition, nLongueur - 1))

End Property

Property Get Status() As String
    ' Renvoie le statut excution/enregistrement du fichier courant

    ' Dclare une variable qui contiendra la valeur renvoye par mciSendString
   Dim nRenvoyer As Integer, nLongueur As Integer
    
   ' Dclare une variable qui contiendra la chane de renvoi mciSendString
   Dim sStatut As String * 255
    
    ' Si aucun fichier n'est ouvert, ferme la procdure
   If sPseudonyme = "" Then Exit Property

   nRenvoyer = mciSendString("Status " & sPseudonyme & " mode", sStatut, 255, 0)
    
   nLongueur = InStr(sStatut, Chr$(0))
   Status = Left$(sStatut, nLongueur - 1)
    
End Property


