#! /usr/bin/env ruby

require 'webrick'
include WEBrick

progress = 0
colorChanged = false

server = HTTPServer.new(:Port => 8042)
server.mount('/', HTTPServlet::FileHandler, './docroot')

server.mount_proc('/whatsup') do |request, response|
  response['Content-Type'] = 'text/plain'
  progress += rand(5) + 1
  progress = 100 if progress > 100
  script = %{
    filler.style.width = '#{progress}%';
    percent.firstChild.nodeValue = '#{progress}%';
  }
  if progress > 50 and !colorChanged
    colorChanged = true
    script += %{
      Element.addClassName(percent, 'over50');
    }
  end
  # Arriv au bout ?  Remise  zro pour la prochaine fois ;-)
  if 100 == progress
    script += %{
      Element.removeClassName(status, 'working');
      Element.addClassName(status, 'done');
    }
    progress = 0
  colorChanged = false
  else
    script += %{
      gProgressTimer = window.setTimeout('checkProgress("' + id + '")', INTERVAL);
    }
  end
  # Nettoyer le script (pensons les yeux des dbogueurs !)
  # --> on vire l'indentation inutile et les lignes vides
  script.gsub!(/^\s+/, '')
  response.body = script
end

trap('INT') { server.shutdown }

srand
server.start
