/*
 * Script de l'exemple de rponse JSON
 * (pas de Prototype pour la partie AJAX).
 *
 * Ncessite Prototype 1.4+
 */

INTERVAL = 2000;
var gLookupTimer = 0;

function getRequester() {
	var result = false;
/*@cc_on @*/
/*@if (@_jscript_version >= 5)
	try {
		result = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			result = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (E) {
			result = false;
		}
	}
@end @*/
	if (!result && 'undefined' != typeof XMLHttpRequest) {
		try {
			result = new XMLHttpRequest();
		} catch (e) {
			result = false;
		}
	}
	return result;
} // getRequester

function loadStats() {
	window.clearTimeout(gLookupTimer);
	var requester = getRequester();
	requester.onreadystatechange = function() {
		if (4 == requester.readyState && 200 == requester.status) {
			var data = $A(eval(requester.responseText));
			updateStats(data);
			gLookupTimer = window.setTimeout('loadStats()', INTERVAL);
		}
	};
	requester.open('GET', '/stats', true);
	requester.send(null);
} // loadStats

function updateStats(data) {
	data.each(function(stock) {
		var bar = $('progress-' + stock.symbol);
		var filler = document.getElementsByClassName('pbColorFill', bar).first();
		var percent = document.getElementsByClassName('pbPercentage', bar).first();
		var comment = document.getElementsByClassName('pbComment', bar).first();
		filler.style.width = stock.percent + '%';
		percent.firstChild.nodeValue = stock.percent + '%';
		comment.firstChild.nodeValue = stock.symbol.toUpperCase() + ' ' + stock.comment;
		if (stock.percent > 50)
			Element.addClassName(percent, 'over50');
		else
			Element.removeClassName(percent, 'over50');
	});
} // updateStats

Event.observe(window, 'load', loadStats, false);
