/*
 * "Bien Dvelopper pour le Web 2.0", Chapitre 8 : APIs REST.
 *
 * Exemple sur Amazon Web Services / E-Commerce Service 4.0.
 *
 * Ncessite Prototype 1.5.0_rc1 ou ultrieur et GoogleAJAXSLT 0.5
 * ou ultrieur.
 */

// Noms des mois pour le reformatage des dates
MONTH_NAMES = [ 'janvier', 'fvrier', 'mars', 'avril', 'mai', 'juin',
    'juillet', 'aot', 'septembre', 'octobre', 'novembre', 'dcembre' ];
// Reformateur de prix
PRICER = new Template('#{euros},#{cents}&euro;');
// Expressions rationnelles de recherche de date et de prix
RE_DATE = '(<span class="date">)([0-9-]+)(</span>)';
RE_PRICE = '(<span class="price">)([0-9]+)(</span>)';

// Contiendra le DOM de la feuille de style XSL/T pour les livres, charge au
// dbut de l'excution.
var xsltSheet;

// Ajuste le texte issu de XSL/T pour reformater les dates et prix fournis par
// AWS/ECS.
function adjustData(text) {
    text = text.gsub(RE_DATE, function(match) {
        var comps = match[2].split('-');
        comps = comps.map(function(s) { return parseInt(s, 10); });
        if (1 == comps[2])
            comps[2] = '1er';
        var date = comps[2] + ' ' + MONTH_NAMES[comps[1] - 1] + ' ' + comps[0];
        return match[1] + date + match[3];
    });
    text = text.gsub(RE_PRICE, function(match) {
        var centsPos = match[2].length - 2;
        var price = {
            euros: match[2].substring(0, centsPos),
            cents: match[2].substring(centsPos)
        };
        return match[1] + PRICER.evaluate(price) + match[3];
    });
    return text;
} // adjustData

// La page vient de se charger : chargement de la feuille XSL/T qui
// conditionne la disponibilit d'une recherche AJAX, et redirection
// du formulaire vers de l'AJAX.
function bindForm() {
    new Ajax.Request('xsl/books.xsl', {
        method: 'get',
        onSuccess: function(requester) {
            // IE et Opera ne recuperent pas correctement responseXML, alors
            // on re-parse manuellement...
            xsltSheet = xmlParse(requester.responseText);
            $('btnSearch').disabled = false;
        }
    });
    Event.observe('searchForm', 'submit', hookToAJAX);
} // bindForm

// Traitement AJAX du formulaire.
function hookToAJAX(event) {
    Event.stop(event);
    var form = $('searchForm');
    $('indicator').update('');
    $('indicator').show();
    $('results').update('');
    // En raison des contraintes de scu sur Firefox et d'autres, on
    // n'interroge pas un site tiers directement : on passe par un
    // intermdiaire sur notre propre serveur.
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(form.action) + '?' +
        encodeURIComponent(Form.serialize(form)),
        onFailure: function() {
            $('indicator').hide();
        },
        onSuccess: function(requester) {
            $('indicator').update('Mise en forme&#8230;');
            // Le boulot "lourd" est dport de 10ms pour laisser le temps au
            // texte de l'indicateur d'tre affich ;-)
            var tmr = window.setTimeout(function() {
                window.clearTimeout(tmr);
                var html = xsltProcess(requester.responseXML, xsltSheet);
                html = adjustData(html);
                $('results').update(html);
                $('indicator').hide();
            }, 10);
        }
    });
} // hookToAJAX

// En cas d'exception, masquer l'indicateur de progression et afficher
// l'exception dans une bote de message.
Ajax.Responders.register({ onException: function(requester, e) {
    $('indicator').hide();
    alert(e);
}});

// viter la console de journalisation de Google AJAXSLT.
logging__ = false;

Event.observe(window, 'load', bindForm);
