/*
 * "Bien Dvelopper pour le Web 2.0", Chapitre 9 : Flux RSS / Atom.
 *
 * Exemple sur le flux Atom du Standblog.
 *
 * Ncessite Prototype 1.5.0_rc1 ou ultrieur et GoogleAJAXSLT 0.5
 * ou ultrieur.
 */

FEED_URL = 'http://standblog.org/dotclear/atom.php';

RE_TIMESTAMP = '(<span class="timestamp">)(.*?)(</span>)';
RE_W3DTF = '^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})([+-]\\d{2}:\\d{2}|Z)$';

// Contiendra le DOM de la feuille de style XSL/T pour les brves, charge au
// dbut de l'excution.
var xsltSheet;

function w3dtfToDate(text) {
    // MSIE ne gre par correctement Date.parse et new Date... On doit
    // recomposer manuellement.
    var comps = $A(text.match(RE_W3DTF)).map(function(s, index) {
        return 0 == index || 7 == index ? s : parseInt(s, 10);
    });
    var result = new Date();
    with (result) {
        setUTCFullYear(comps[1]);
        setUTCMonth(comps[2]);
        setUTCDate(comps[3]);
        setUTCHours(comps[4]);
        setUTCMinutes(comps[5]);
        setUTCSeconds(comps[6]);
    }
    var utcOffset = 0;
    if ('Z' != comps[7]) {
        var sign = '-' == comps[7].charAt(0) ? -1 : 1;
        var hours = parseInt(comps[7].substring(1, 3), 10);
        var minutes = parseInt(comps[7].substring(4), 10);
        utcOffset = sign * (hours * 60 + minutes);
    }
    result = new Date(result.getTime() - utcOffset * 60000);
    return result;
} // w3dtfToDate

function adjustData(html) {
    var html = html.gsub(RE_TIMESTAMP, function(match) {
        match[2] = w3dtfToDate(match[2]).toLocaleString();
        return match[1] + match[2] + match[3];
    });
    // On ne peut pas utiliser le moteur de RegExp, car Konqueror plante
    // sur des textes potentiellement trs gros...  Donc, on y a va  la
    // main.  Youpi !
    DIV_OPENER = '<div class="content"';
    DIV_CLOSER = '</div>';
    var start = 0;
    var pos = html.indexOf(DIV_OPENER, start);
    var result = '';
    while (-1 != pos) {
        var openerEnd = html.indexOf('<div>', pos) + 5;
        result += html.substring(start, openerEnd);
        var closerStart = html.indexOf(DIV_CLOSER, openerEnd);
        result += safeUnescape(html.substring(openerEnd, closerStart));
        start = closerStart;
        pos = html.indexOf(DIV_OPENER, start);
    }
    result += html.substring(start);
    return result;
} // adjustData

// Le code du unescapeHTML de Prototype va rencontrer des limitations
// de taille sur certains navigateurs, alors on y va  la main...
function safeUnescape(text) {
    TRANSITIONS = { 'lt': '<', 'gt': '>', 'quot': '"',
        'apos': "'", 'amp': '&' };
    for (var entity in TRANSITIONS) {
        var re = new RegExp('&' + entity + ';', 'mg');
        text = text.replace(re, TRANSITIONS[entity]);
    }
    return text;
} // safeUnescape

function getFeed() {
    $('results').update('');
    showIndicator();
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(FEED_URL),
        onFailure: hideIndicator,
        onSuccess: function(requester) {
            $('indicator').update('Mise en forme&#8230;');
            var tmr = window.setTimeout(function() {
                window.clearTimeout(tmr);
                var data = xmlParse(requester.responseText);
                var html = xsltProcess(data, xsltSheet);
                $('results').update(adjustData(html));
                bindTogglers();
                hideIndicator();
            }, 10);
        }
    });
} // getFeed

function bindTogglers() {
    $$('#results .toggler a').each(function(link) {
        Event.observe(link, 'click', handleToggler);
    });
} // bindTogglers

function handleToggler(e) {
    Event.stop(e);
    var toggler = $(Event.element(e)).up('p');
    new Effect.Parallel([
        new Effect.BlindDown(toggler.next('div')),
        new Effect.Fade(toggler)
    ], { duration: 2.0 });
} // handleToggler

function showIndicator() {
    with ($('indicator')) {
        update('');
        show();
    }
} // showIndicator

function hideIndicator() {
    $('indicator').hide();
} // hideIndicator

function initPage() {
    new Ajax.Request('xsl/standblog.xsl', {
        method: 'get',
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            // IE et Opera ne recuperent pas correctement responseXML, alors
            // on re-parse manuellement...
            xsltSheet = xmlParse(requester.responseText);
            getFeed();
        }
    });
} // initPage

// En cas d'exception, masquer l'indicateur de progression et afficher
// l'exception dans une bote de message.
Ajax.Responders.register({ onException: function(requester, e) {
    $('indicator').hide();
    alert(e);
}});

// viter la console de journalisation de Google AJAXSLT.
logging__ = false;

Event.observe(window, 'load', initPage);
