/*
 * "Bien Dvelopper pour le Web 2.0", Chapitre 9 : Flux RSS / Atom.
 *
 * Exemple sur les brves Client Web du JDN Dveloppeur.
 *
 * Ncessite Prototype 1.5.0_rc1 ou ultrieur et GoogleAJAXSLT 0.5
 * ou ultrieur.
 */

FEED_URL = 'http://developpeur.journaldunet.com/rss/breve/client-web/';

RE_TITLE = '(<a .*?>)Client Web\\s*&gt;\\s*(.*?)(</a>)';
RE_TIMESTAMP = '(<span class="timestamp">)(.*?)(</span>)';

// Contiendra le DOM de la feuille de style XSL/T pour les brves, charge au
// dbut de l'excution.
var xsltSheet;

function adjustData(html) {
    var html = html.gsub(RE_TIMESTAMP, function(match) {
        match[2] = new Date(match[2]).toLocaleString();
        return match[1] + match[2] + match[3];
    });
    html = html.replace(new RegExp(RE_TITLE, 'img'), '$1$2$3');
    return html;
} // adjustData

function getFeed() {
    $('results').update('');
    showIndicator();
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(FEED_URL),
        onFailure: hideIndicator,
        onSuccess: function(requester) {
            $('indicator').update('Mise en forme&#8230;');
            var tmr = window.setTimeout(function() {
                window.clearTimeout(tmr);
                var data = xmlParse(requester.responseText);
                var html = xsltProcess(data, xsltSheet);
                $('results').update(adjustData(html));
                hideIndicator();
            }, 10);
        }
    });
} // getFeed

function showIndicator() {
    with ($('indicator')) {
        update('');
        show();
    }
} // showIndicator

function hideIndicator() {
    $('indicator').hide();
} // hideIndicator

function initPage() {
    new Ajax.Request('xsl/breves.xsl', {
        method: 'get',
		onLoading: showIndicator,
		onComplete: hideIndicator,
        onSuccess: function(requester) {
            // IE et Opera ne recuperent pas correctement responseXML, alors
            // on re-parse manuellement...
            xsltSheet = xmlParse(requester.responseText);
            getFeed();
        }
    });
} // initPage

// En cas d'exception, masquer l'indicateur de progression et afficher
// l'exception dans une bote de message.
Ajax.Responders.register({ onException: function(requester, e) {
    $('indicator').hide();
    alert(e);
}});

// viter la console de journalisation de Google AJAXSLT.
logging__ = false;

Event.observe(window, 'load', initPage);
