/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.AbstractMarshaller;
import org.jboss.xml.binding.AttributesImpl;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentWriter;
import org.jboss.xml.binding.DelegatingObjectModelProvider;
import org.jboss.xml.binding.GenericObjectModelProvider;
import org.jboss.xml.binding.ObjectModelProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(XsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final Map uriByNsName = new HashMap();
    private Object root;

    public void marshal(Reader schema, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = new InputSource(schema);
        XSParser xsParser = new XSParser();
        xsParser.setValidating(false);
        XSSchema xsSchema = xsParser.parse(source);
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootQNames.isEmpty()) {
            XSElement[] elements = xsSchema.getElements();
            for (int i = 0; i < elements.length; ++i) {
                log.info("marshalling " + elements[i].getName().getLocalName());
                this.processElement(elements[i], null, 1);
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XsQName rootName = new XsQName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
                XSElement xsRoot = xsSchema.getElement(rootName);
                if (xsRoot == null) {
                    throw new IllegalStateException("Root element not found: " + rootName);
                }
                this.processElement(xsRoot, null, 1);
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
    }

    public void declareNamespace(String name, String uri) {
        boolean nonEmptyName = name != null && name.length() > 0;
        String localName = nonEmptyName ? name : "xmlns";
        this.uriByNsName.put(localName, uri);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
        if (prefix != null && prefix.length() > 0) {
            String uri = (String)this.uriByNsName.get(prefix);
            if (uri == null) {
                throw new IllegalStateException("Namespace prefix " + prefix + " is not declared. Use declareNamespace().");
            }
        } else {
            Object uri = null;
        }
    }

    public void addAttribute(String namespaceUri, String prefix, String localName, String type, String value) {
        this.declareNamespace(prefix, namespaceUri);
        this.addAttribute(prefix, localName, type, value);
    }

    private final void processElement(XSElement element, AttributesImpl attrs, int maxOccurs) throws SAXException {
        XSType type = element.getType();
        this.processType(element, type, attrs, maxOccurs);
    }

    private final void processType(XSElement element, XSType type, AttributesImpl attrs, int maxOccurs) throws SAXException {
        if (type.isSimple()) {
            XSSimpleType simpleType = type.getSimpleType();
            this.processSimpleType(element, simpleType, null);
        } else {
            XSComplexType complexType = type.getComplexType();
            this.processComplexType(element, complexType, attrs, maxOccurs);
        }
    }

    private final void processSimpleType(XSElement element, XSSimpleType type, Attributes attrs) {
        XsQName name;
        String prefix;
        String qName;
        if (type.isAtomic()) {
            if (log.isTraceEnabled()) {
                log.trace("atomic simple type");
            }
        } else if (type.isList()) {
            if (log.isTraceEnabled()) {
                log.trace("list of types");
            }
        } else if (type.isRestriction()) {
            if (log.isTraceEnabled()) {
                log.trace("restricted type");
            }
        } else if (type.isUnion()) {
            if (log.isTraceEnabled()) {
                log.trace("union of types");
            }
        } else {
            throw new IllegalStateException("Simple type is not atomic, list, restriction or union!");
        }
        String string = qName = (prefix = (name = element.getName()).getPrefix()) == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
        if (this.stack.isEmpty()) {
            Object parent = this.provider.getRoot(this.root, null, name.getNamespaceURI(), name.getLocalName());
            if (parent == null) {
                return;
            }
            char[] ch = parent.toString().toCharArray();
            this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
            this.content.characters(ch, 0, ch.length);
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        } else {
            Object parent = this.stack.peek();
            Object value = this.provider.getElementValue(parent, null, name.getNamespaceURI(), name.getLocalName());
            if (value != null) {
                char[] ch = value.toString().toCharArray();
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
                this.content.characters(ch, 0, ch.length);
                this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
            }
        }
    }

    private final void processComplexType(XSElement element, XSComplexType type, AttributesImpl addedAttrs, int maxOccurs) throws SAXException {
        String qName;
        Object parent;
        XsQName xsName = element.getName();
        boolean popRoot = false;
        if (this.stack.isEmpty()) {
            parent = this.provider.getRoot(this.root, null, xsName.getNamespaceURI(), xsName.getLocalName());
            if (parent == null) {
                return;
            }
            AttributesImpl attrs = addedAttrs;
            if (type.getAttributes() != null) {
                if (attrs == null) {
                    attrs = this.provideAttributes(type.getAttributes(), parent);
                } else {
                    attrs.addAll(this.provideAttributes(type.getAttributes(), parent));
                }
            }
            qName = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
            this.content.startElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName, attrs);
            this.stack.push(parent);
            popRoot = true;
        } else {
            parent = this.stack.peek();
        }
        Object children = null;
        if (!popRoot) {
            children = this.provider.getChildren(parent, null, xsName.getNamespaceURI(), xsName.getLocalName());
        }
        if (children != null) {
            qName = null;
            if (maxOccurs == 1) {
                AttributesImpl attrs = addedAttrs;
                if (type.getAttributes() != null) {
                    if (attrs != null) {
                        attrs.addAll(this.provideAttributes(type.getAttributes(), parent));
                    } else {
                        attrs = this.provideAttributes(type.getAttributes(), parent);
                    }
                }
                qName = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
                this.content.startElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName, attrs);
            }
            this.handleChildren(element, type, children, addedAttrs, maxOccurs);
            if (qName != null) {
                this.content.endElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName);
            }
        } else if (type.hasSimpleContent()) {
            this.processSimpleType(element, type.getSimpleContent().getType().getSimpleType(), null);
        } else if (type.isEmpty()) {
            XsQName name = element.getName();
            Object value = this.provider.getElementValue(parent, null, name.getNamespaceURI(), name.getLocalName());
            if (Boolean.TRUE.equals(value)) {
                String prefix = name.getPrefix();
                String qName2 = prefix == null || prefix.length() == 0 ? name.getLocalName() : prefix + ':' + name.getLocalName();
                AttributesImpl ownAttrs = this.provideAttributes(type.getAttributes(), parent);
                if (ownAttrs != null) {
                    if (addedAttrs != null) {
                        ownAttrs.addAll(ownAttrs);
                    }
                } else {
                    ownAttrs = addedAttrs;
                }
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName2, ownAttrs);
                this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName2);
            }
        } else {
            XSParticle particle = type.getParticle();
            if (particle != null) {
                this.processParticle(particle);
            }
        }
        if (popRoot) {
            this.stack.pop();
            qName = xsName.getPrefix() == null ? xsName.getLocalName() : xsName.getPrefix() + ":" + xsName.getLocalName();
            this.content.endElement(xsName.getNamespaceURI(), xsName.getLocalName(), qName);
        }
    }

    private void handleChildren(XSElement parent, XSComplexType type, Object children, AttributesImpl addedAttrs, int maxOccurs) throws SAXException {
        if (children != null) {
            if (children instanceof List) {
                this.handleChildrenList(parent, type, (List)children, addedAttrs, maxOccurs);
            } else if (children instanceof Collection) {
                this.handleChildrenIterator(parent, type, ((Collection)children).iterator(), addedAttrs, maxOccurs);
            } else if (children instanceof Iterator) {
                this.handleChildrenIterator(parent, type, (Iterator)children, addedAttrs, maxOccurs);
            } else if (children.getClass().isArray()) {
                this.handleChildrenArray(parent, type, (Object[])children, addedAttrs, maxOccurs);
            } else {
                this.handleChild(parent, type, children, addedAttrs);
            }
        }
    }

    private AttributesImpl provideAttributes(XSAttributable[] xsAttrs, Object container) {
        AttributesImpl attrs = new AttributesImpl(xsAttrs.length);
        for (int i = 0; i < xsAttrs.length; ++i) {
            XSAttributable attributable = xsAttrs[i];
            if (!(attributable instanceof XSAttribute)) continue;
            XSAttribute attr = (XSAttribute)attributable;
            XsQName attrQName = attr.getName();
            Object attrValue = this.provider.getAttributeValue(container, null, attrQName.getNamespaceURI(), attrQName.getLocalName());
            if (attrValue != null) {
                String prefix = attrQName.getPrefix();
                String qName = prefix == null || prefix.length() == 0 ? attrQName.getLocalName() : attrQName.getPrefix() + ':' + attrQName.getLocalName();
                attrs.add(attrQName.getNamespaceURI(), attrQName.getLocalName(), qName, attr.getType().getName().getLocalName(), attrValue.toString());
                continue;
            }
            log.info("no val for attr " + attrQName.getLocalName() + ", container=" + container);
        }
        return attrs;
    }

    private final void processParticle(XSParticle particle) throws SAXException {
        if (particle.isElement()) {
            XSElement element = particle.getElement();
            this.processElement(element, null, particle.getMaxOccurs());
        } else if (particle.isGroup()) {
            XSGroup group = particle.getGroup();
            this.processGroup(group);
        } else if (particle.isWildcard()) {
            if (log.isTraceEnabled()) {
                log.trace("any");
            }
        } else {
            throw new IllegalStateException("Particle is not an element, group or wildcard!");
        }
    }

    private final void processGroup(XSGroup group) throws SAXException {
        if (!(group.isSequence() || group.isChoice() || group.isAll())) {
            throw new IllegalStateException("Group is not a sequence, choice or all!");
        }
        XSParticle[] particles = group.getParticles();
        for (int i = 0; i < particles.length; ++i) {
            XSParticle particle = particles[i];
            this.processParticle(particle);
        }
    }

    private void handleChildrenList(XSElement parent, XSComplexType type, List children, AttributesImpl addedAttrs, int maxOccurs) throws SAXException {
        this.handleChildrenIterator(parent, type, children.iterator(), addedAttrs, maxOccurs);
    }

    private void handleChildrenIterator(XSElement parent, XSComplexType type, Iterator children, AttributesImpl addedAttrs, int maxOccurs) throws SAXException {
        XsQName name = parent.getName();
        String qName = null;
        if (maxOccurs == -1 || maxOccurs > 0) {
            String string = qName = name.getPrefix() == null ? name.getLocalName() : name.getPrefix() + ':' + name.getLocalName();
        }
        while (children.hasNext()) {
            Object child = children.next();
            if (qName != null) {
                AttributesImpl attrs = addedAttrs;
                if (type.getAttributes() != null) {
                    if (attrs != null) {
                        attrs.addAll(this.provideAttributes(type.getAttributes(), child));
                    } else {
                        attrs = this.provideAttributes(type.getAttributes(), child);
                    }
                }
                this.content.startElement(name.getNamespaceURI(), name.getLocalName(), qName, attrs);
            }
            this.handleChild(parent, type, child, addedAttrs);
            if (qName == null) continue;
            this.content.endElement(name.getNamespaceURI(), name.getLocalName(), qName);
        }
    }

    private void handleChildrenArray(XSElement parent, XSComplexType type, Object[] children, AttributesImpl addedAttrs, int maxOccurs) throws SAXException {
        this.handleChildrenIterator(parent, type, Arrays.asList(children).iterator(), addedAttrs, maxOccurs);
    }

    private void handleChild(XSElement parent, XSComplexType type, Object child, AttributesImpl addedAttrs) throws SAXException {
        AttributesImpl ownAttrs;
        this.stack.push(child);
        XSAttributable[] xsAttrs = type.getAttributes();
        AttributesImpl attributesImpl = ownAttrs = xsAttrs == null ? null : this.provideAttributes(xsAttrs, child);
        if (ownAttrs != null) {
            if (addedAttrs != null) {
                ownAttrs.addAll(addedAttrs);
            }
        } else {
            ownAttrs = addedAttrs;
        }
        if (type.hasSimpleContent()) {
            this.processSimpleType(parent, type.getSimpleContent().getType().getSimpleType(), ownAttrs);
        } else if (!type.isEmpty() && type.getParticle() != null) {
            this.processParticle(type.getParticle());
        } else {
            XSSchema xsSchema;
            AbstractMarshaller.ClassMapping mapping = this.getClassMapping(child.getClass());
            InputSource source = new InputSource(mapping.schemaUrl);
            XSParser xsParser = new XSParser();
            xsParser.setValidating(false);
            try {
                xsSchema = xsParser.parse(source);
            }
            catch (Exception e) {
                log.error(e);
                throw new IllegalStateException(e.getMessage());
            }
            XsQName rootName = new XsQName(mapping.namespaceUri, mapping.root);
            XSElement root = xsSchema.getElement(rootName);
            rootName = root.getName();
            String rootPrefix = rootName.getPrefix();
            String rootQName = rootPrefix == null || rootPrefix.length() == 0 ? rootName.getLocalName() : rootPrefix + ':' + rootName.getLocalName();
            AbstractMarshaller.Stack oldStack = this.stack;
            this.stack = new AbstractMarshaller.StackImpl();
            Object oldRoot = this.root;
            this.root = child;
            GenericObjectModelProvider oldProvider = this.provider;
            this.provider = mapping.provider;
            this.content.startElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName, addedAttrs);
            this.processElement(root, addedAttrs, 1);
            this.content.endElement(rootName.getNamespaceURI(), rootName.getLocalName(), rootQName);
            this.root = oldRoot;
            this.stack = oldStack;
            this.provider = oldProvider;
        }
        this.stack.pop();
    }
}

