/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.metadata;

import java.util.LinkedList;
import org.jboss.xml.binding.metadata.XmlDocument;
import org.jboss.xml.binding.metadata.XmlElement;
import org.jboss.xml.binding.metadata.XmlNamespace;
import org.jboss.xml.binding.metadata.unmarshalling.BindingCursor;

public class CursorImpl
implements BindingCursor {
    private final XmlDocument doc;
    private final LinkedList stack = new LinkedList();

    public CursorImpl(XmlDocument doc) {
        this.doc = doc;
    }

    public void startElement(String namespaceURI, String localName) {
        XmlElement element;
        if (this.stack.isEmpty()) {
            XmlNamespace ns = this.doc.getNamespace(namespaceURI);
            element = ns.getElement(localName);
        } else {
            element = (XmlElement)this.stack.getLast();
            if (element != null) {
                element = element.getType().getElement(namespaceURI, localName);
            }
        }
        this.stack.addLast(element);
    }

    public void endElement(String namespaceURI, String localName) {
        this.stack.removeLast();
    }

    public Object getElementBinding() {
        return (XmlElement)this.stack.getLast();
    }

    public Object getParentElementBinding() {
        return this.stack.size() - 2 >= 0 ? this.stack.get(this.stack.size() - 2) : null;
    }
}

