/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.jboss.mx.util.Serialization;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    private Descriptor mbeanDescriptor = null;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private ModelMBeanAttributeInfo[] modelAttributes = null;
    private ModelMBeanConstructorInfo[] modelConstructors = null;
    private ModelMBeanOperationInfo[] modelOperations = null;
    private ModelMBeanNotificationInfo[] modelNotifications = null;

    public ModelMBeanInfoSupport(ModelMBeanInfo mbi) {
        super(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), mbi.getNotifications());
        this.modelAttributes = (ModelMBeanAttributeInfo[])mbi.getAttributes();
        this.modelConstructors = (ModelMBeanConstructorInfo[])mbi.getConstructors();
        this.modelOperations = (ModelMBeanOperationInfo[])mbi.getOperations();
        this.modelNotifications = (ModelMBeanNotificationInfo[])mbi.getNotifications();
        try {
            this.setMBeanDescriptor(mbi.getMBeanDescriptor());
        }
        catch (MBeanException e) {
            throw new RuntimeException("Cannot set MBean descriptor", e);
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] modelAttributes, ModelMBeanConstructorInfo[] modelConstructors, ModelMBeanOperationInfo[] modelOperations, ModelMBeanNotificationInfo[] modelNotifications) {
        super(className, description, null == modelAttributes ? new ModelMBeanAttributeInfo[]{} : modelAttributes, null == modelConstructors ? new ModelMBeanConstructorInfo[]{} : modelConstructors, null == modelOperations ? new ModelMBeanOperationInfo[]{} : modelOperations, null == modelNotifications ? new ModelMBeanNotificationInfo[]{} : modelNotifications);
        this.modelAttributes = (ModelMBeanAttributeInfo[])super.getAttributes();
        this.modelConstructors = (ModelMBeanConstructorInfo[])super.getConstructors();
        this.modelOperations = (ModelMBeanOperationInfo[])super.getOperations();
        this.modelNotifications = (ModelMBeanNotificationInfo[])super.getNotifications();
        try {
            this.setMBeanDescriptor(this.createDefaultDescriptor());
        }
        catch (MBeanException e) {
            throw new RuntimeException("Cannot set MBean descriptor", e);
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] modelAttributes, ModelMBeanConstructorInfo[] modelConstructors, ModelMBeanOperationInfo[] modelOperations, ModelMBeanNotificationInfo[] modelNotifications, Descriptor mbeandescriptor) throws RuntimeOperationsException {
        super(className, description, null == modelAttributes ? new ModelMBeanAttributeInfo[]{} : modelAttributes, null == modelConstructors ? new ModelMBeanConstructorInfo[]{} : modelConstructors, null == modelOperations ? new ModelMBeanOperationInfo[]{} : modelOperations, null == modelNotifications ? new ModelMBeanNotificationInfo[]{} : modelNotifications);
        this.modelAttributes = (ModelMBeanAttributeInfo[])super.getAttributes();
        this.modelConstructors = (ModelMBeanConstructorInfo[])super.getConstructors();
        this.modelOperations = (ModelMBeanOperationInfo[])super.getOperations();
        this.modelNotifications = (ModelMBeanNotificationInfo[])super.getNotifications();
        try {
            this.setMBeanDescriptor(mbeandescriptor);
        }
        catch (MBeanException e) {
            throw new RuntimeException("Cannot set MBean descriptor", e);
        }
    }

    public Descriptor[] getDescriptors(String descrType) throws MBeanException {
        if (descrType == null) {
            ArrayList<Descriptor> list2 = new ArrayList<Descriptor>(100);
            list2.add(this.mbeanDescriptor);
            list2.addAll(this.getAttributeDescriptors().values());
            list2.addAll(this.getOperationDescriptors().values());
            list2.addAll(this.getNotificationDescriptors().values());
            list2.addAll(this.getConstructorDescriptors().values());
            return list2.toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("mbean")) {
            return new Descriptor[]{this.mbeanDescriptor};
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return this.getAttributeDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return this.getOperationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return this.getNotificationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return this.getConstructorDescriptors().values().toArray(new Descriptor[0]);
        }
        throw new IllegalArgumentException("unknown descriptor type: " + descrType);
    }

    public Descriptor getDescriptor(String descrName, String descrType) throws MBeanException {
        if (descrType == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor type"));
        }
        if (descrType.equalsIgnoreCase("mbean")) {
            return this.mbeanDescriptor;
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return this.getAttributeDescriptor(descrName);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return this.getOperationDescriptor(descrName);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return this.getConstructorDescriptor(descrName);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return this.getNotificationDescriptor(descrName);
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("unknown descriptor type: " + descrType));
    }

    public void setDescriptors(Descriptor[] inDescriptors) throws MBeanException {
        for (int i = 0; i < inDescriptors.length; ++i) {
            if (inDescriptors[i] == null || !inDescriptors[i].isValid()) continue;
            this.setDescriptor(inDescriptors[i], (String)inDescriptors[i].getFieldValue("descriptorType"));
        }
    }

    public void setDescriptor(Descriptor descr, String descrType) throws MBeanException {
        if (descr == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor"));
        }
        if (!descr.isValid()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("not a valid descriptor"));
        }
        if (descrType == null) {
            descrType = (String)descr.getFieldValue("descriptorType");
        }
        if (descrType.equalsIgnoreCase("mbean")) {
            this.setMBeanDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("attribute")) {
            ModelMBeanAttributeInfo info = this.getAttribute((String)descr.getFieldValue("name"));
            if (info != null) {
                info.setDescriptor(descr);
            }
        } else if (descrType.equalsIgnoreCase("operation")) {
            ModelMBeanOperationInfo info = this.getOperation((String)descr.getFieldValue("name"));
            if (info != null) {
                info.setDescriptor(descr);
            }
        } else if (descrType.equalsIgnoreCase("constructor")) {
            ModelMBeanConstructorInfo info = this.getConstructor((String)descr.getFieldValue("name"));
            if (info != null) {
                info.setDescriptor(descr);
            }
        } else if (descrType.equalsIgnoreCase("notification")) {
            ModelMBeanNotificationInfo info = this.getNotification((String)descr.getFieldValue("name"));
            if (info != null) {
                info.setDescriptor(descr);
            }
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("unknown descriptor type: " + descrType));
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String inName) throws MBeanException {
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null attribute name"));
        }
        for (int i = 0; i < this.modelAttributes.length; ++i) {
            if (!this.modelAttributes[i].getName().equals(inName)) continue;
            return this.modelAttributes[i];
        }
        return null;
    }

    public ModelMBeanOperationInfo getOperation(String inName) throws MBeanException {
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null operation name"));
        }
        for (int i = 0; i < this.modelOperations.length; ++i) {
            if (!this.modelOperations[i].getName().equals(inName)) continue;
            return this.modelOperations[i];
        }
        return null;
    }

    public ModelMBeanConstructorInfo getConstructor(String inName) throws MBeanException {
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null constructor name"));
        }
        for (int i = 0; i < this.modelConstructors.length; ++i) {
            if (!this.modelConstructors[i].getName().equals(inName)) continue;
            return this.modelConstructors[i];
        }
        return null;
    }

    public ModelMBeanNotificationInfo getNotification(String inName) throws MBeanException {
        if (inName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null notification name"));
        }
        for (int i = 0; i < this.modelNotifications.length; ++i) {
            if (!this.modelNotifications[i].getName().equals(inName)) continue;
            return this.modelNotifications[i];
        }
        return null;
    }

    public MBeanAttributeInfo[] getAttributes() {
        return super.getAttributes();
    }

    public MBeanOperationInfo[] getOperations() {
        return super.getOperations();
    }

    public MBeanConstructorInfo[] getConstructors() {
        return super.getConstructors();
    }

    public MBeanNotificationInfo[] getNotifications() {
        return super.getNotifications();
    }

    public Descriptor getMBeanDescriptor() throws MBeanException {
        return this.mbeanDescriptor;
    }

    public void setMBeanDescriptor(Descriptor inDescriptor) throws MBeanException, RuntimeOperationsException {
        if (inDescriptor == null) {
            inDescriptor = this.createDefaultDescriptor();
        }
        if (inDescriptor.isValid() && this.isMBeanDescriptorValid(inDescriptor)) {
            this.addDefaultMBeanDescriptorFields(inDescriptor);
            this.mbeanDescriptor = inDescriptor;
        }
    }

    private boolean isMBeanDescriptorValid(Descriptor inDescriptor) {
        String name = (String)inDescriptor.getFieldValue("name");
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid null name"));
        }
        String descriptorType = (String)inDescriptor.getFieldValue("descriptorType");
        if (!"mbean".equalsIgnoreCase(descriptorType)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptorType, for mbean '" + name + "' expected 'MBean' but got: " + descriptorType));
        }
        return true;
    }

    public Descriptor getDescriptor(String descrName) throws MBeanException {
        if (descrName.equals(this.mbeanDescriptor.getFieldValue("name"))) {
            return this.mbeanDescriptor;
        }
        Descriptor descr = null;
        descr = (Descriptor)this.getAttributeDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getOperationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getNotificationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getConstructorDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        return null;
    }

    public synchronized Object clone() {
        ModelMBeanInfoSupport clone = (ModelMBeanInfoSupport)super.clone();
        clone.mbeanDescriptor = (Descriptor)this.mbeanDescriptor.clone();
        return clone;
    }

    private void addDefaultMBeanDescriptorFields(Descriptor descr) {
        if (descr.getFieldValue("name") == null || descr.getFieldValue("name").equals("")) {
            descr.setField("name", this.getClassName());
        }
        if (descr.getFieldValue("descriptorType") == null) {
            descr.setField("descriptorType", "mbean");
        }
        if (!((String)descr.getFieldValue("descriptorType")).equalsIgnoreCase("mbean")) {
            descr.setField("descriptorType", "mbean");
        }
        if (descr.getFieldValue("displayName") == null) {
            descr.setField("displayName", this.getClassName());
        }
        if (descr.getFieldValue("persistPolicy") == null) {
            descr.setField("persistPolicy", "Never");
        }
        if (descr.getFieldValue("log") == null) {
            descr.setField("log", "F");
        }
        if (descr.getFieldValue("visibility") == null) {
            descr.setField("visibility", "1");
        }
    }

    private Descriptor createDefaultDescriptor() {
        return new DescriptorSupport(new String[]{"name=" + this.getClassName(), "descriptorType=mbean", "displayName=" + this.getClassName(), "persistPolicy=Never", "log=F", "visibility=1"});
    }

    private Map getAttributeDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.modelAttributes.length; ++i) {
            map.put(this.modelAttributes[i].getName(), this.modelAttributes[i].getDescriptor());
        }
        return map;
    }

    private Descriptor getAttributeDescriptor(String descrName) {
        for (int i = 0; i < this.modelAttributes.length; ++i) {
            if (!this.modelAttributes[i].getName().equals(descrName)) continue;
            return this.modelAttributes[i].getDescriptor();
        }
        return null;
    }

    private Map getOperationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.modelOperations.length; ++i) {
            map.put(this.modelOperations[i].getName(), this.modelOperations[i].getDescriptor());
        }
        return map;
    }

    private Descriptor getOperationDescriptor(String descrName) {
        for (int i = 0; i < this.modelOperations.length; ++i) {
            if (!this.modelOperations[i].getName().equals(descrName)) continue;
            return this.modelOperations[i].getDescriptor();
        }
        return null;
    }

    private Map getConstructorDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.modelConstructors.length; ++i) {
            map.put(this.modelConstructors[i].getName(), this.modelConstructors[i].getDescriptor());
        }
        return map;
    }

    private Descriptor getConstructorDescriptor(String descrName) {
        for (int i = 0; i < this.modelConstructors.length; ++i) {
            if (!this.modelConstructors[i].getName().equals(descrName)) continue;
            return this.modelConstructors[i].getDescriptor();
        }
        return null;
    }

    private Map getNotificationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        for (int i = 0; i < this.modelNotifications.length; ++i) {
            map.put(this.modelNotifications[i].getName(), this.modelNotifications[i].getDescriptor());
        }
        return map;
    }

    private Descriptor getNotificationDescriptor(String descrName) {
        for (int i = 0; i < this.modelNotifications.length; ++i) {
            if (!this.modelNotifications[i].getName().equals(descrName)) continue;
            return this.modelNotifications[i].getDescriptor();
        }
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ModelMBeanOperationInfo[] operInfo;
        ModelMBeanNotificationInfo[] notifyInfo;
        ModelMBeanConstructorInfo[] consInfo;
        ModelMBeanAttributeInfo[] attrInfo;
        ObjectInputStream.GetField getField = ois.readFields();
        switch (Serialization.version) {
            case 10: {
                attrInfo = (ModelMBeanAttributeInfo[])getField.get("mmbAttributes", null);
                consInfo = (ModelMBeanConstructorInfo[])getField.get("mmbConstructors", null);
                notifyInfo = (ModelMBeanNotificationInfo[])getField.get("mmbNotifications", null);
                operInfo = (ModelMBeanOperationInfo[])getField.get("mmbOperations", null);
                break;
            }
            default: {
                attrInfo = (ModelMBeanAttributeInfo[])getField.get("modelMBeanAttributes", null);
                consInfo = (ModelMBeanConstructorInfo[])getField.get("modelMBeanConstructors", null);
                notifyInfo = (ModelMBeanNotificationInfo[])getField.get("modelMBeanNotifications", null);
                operInfo = (ModelMBeanOperationInfo[])getField.get("modelMBeanOperations", null);
            }
        }
        Descriptor desc = (Descriptor)getField.get("modelMBeanDescriptor", null);
        if (desc == null) {
            throw new StreamCorruptedException("Null descriptor?");
        }
        this.modelAttributes = null == attrInfo ? new ModelMBeanAttributeInfo[]{} : attrInfo;
        this.modelConstructors = null == consInfo ? new ModelMBeanConstructorInfo[]{} : consInfo;
        this.modelOperations = null == operInfo ? new ModelMBeanOperationInfo[]{} : operInfo;
        this.modelNotifications = null == notifyInfo ? new ModelMBeanNotificationInfo[]{} : notifyInfo;
        try {
            this.setMBeanDescriptor(this.createDefaultDescriptor());
        }
        catch (MBeanException ignore) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        switch (Serialization.version) {
            case 10: {
                putField.put("mmbAttributes", this.modelAttributes);
                putField.put("mmbConstructors", this.modelConstructors);
                putField.put("mmbNotifications", this.modelNotifications);
                putField.put("mmbOperations", this.modelOperations);
                break;
            }
            default: {
                putField.put("modelMBeanAttributes", this.modelAttributes);
                putField.put("modelMBeanConstructors", this.modelConstructors);
                putField.put("modelMBeanNotifications", this.modelNotifications);
                putField.put("modelMBeanOperations", this.modelOperations);
            }
        }
        putField.put("modelMBeanDescriptor", this.mbeanDescriptor);
        oos.writeFields();
    }

    static {
        switch (Serialization.version) {
            case 10: {
                serialVersionUID = -3944083498453227709L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("mmbAttributes", new MBeanAttributeInfo[0].getClass()), new ObjectStreamField("mmbConstructors", new MBeanConstructorInfo[0].getClass()), new ObjectStreamField("mmbNotifications", new MBeanNotificationInfo[0].getClass()), new ObjectStreamField("mmbOperations", new MBeanOperationInfo[0].getClass()), new ObjectStreamField("modelMBeanDescriptor", Descriptor.class)};
                break;
            }
            default: {
                serialVersionUID = -1935722590756516193L;
                serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("modelMBeanAttributes", new MBeanAttributeInfo[0].getClass()), new ObjectStreamField("modelMBeanConstructors", new MBeanConstructorInfo[0].getClass()), new ObjectStreamField("modelMBeanNotifications", new MBeanNotificationInfo[0].getClass()), new ObjectStreamField("modelMBeanOperations", new MBeanOperationInfo[0].getClass()), new ObjectStreamField("modelMBeanDescriptor", Descriptor.class)};
            }
        }
    }
}

