/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.annotation.AdviceMethodFactory;
import org.jboss.aop.instrument.FieldJoinPointGenerator;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.instrument.SecurityActions;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.util.JavassistUtils;
import org.jboss.aop.util.ReflectToJavassist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinPointGenerator {
    public static final String INFO_FIELD = "info";
    public static final String INVOKE_JOINPOINT = "invokeJoinpoint";
    public static final String INVOKE_TARGET = "invokeTarget";
    public static final String DISPATCH = "dispatch";
    protected static final String TARGET_FIELD = "typedTargetObject";
    protected static final String CALLER_FIELD = "callingObject";
    protected static final String GENERATED_CLASS_ADVISOR = GeneratedClassAdvisor.class.getName();
    public static final String GENERATE_JOINPOINT_CLASS = "generateJoinPointClass";
    private static final String CURRENT_ADVICE = "super.currentInterceptor";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_";
    public static final String GENERATOR_PREFIX = "generator_";
    private static final String RETURN_VALUE = "ret";
    private static final String THROWABLE = "t";
    protected static final String ARGUMENTS = "arguments";
    private static final String GET_ARGUMENTS = "getArguments()";
    protected static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
    private final ArrayList<Integer> joinPointArguments;
    private JoinPointInfo oldInfo;
    protected JoinPointInfo info;
    private JoinPointParameters parameters;
    private static int increment;
    private Class advisorClass;
    protected GeneratedClassAdvisor advisor;
    protected String joinpointClassName;
    protected String joinpointFieldName;
    private String joinpointFqn;
    private Field joinpointField;
    private Field generatorField;
    private boolean initialised;
    private ThreadLocal<Set<Integer>> inconsistentTypeArgs;

    protected JoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info, JoinPointParameters parameters, int argumentsSize) {
        int i;
        this.info = info;
        this.parameters = parameters;
        this.advisor = advisor;
        this.advisorClass = advisor.getClass();
        Class<?>[] interfaces = this.advisorClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(InstanceAdvisor.class)) continue;
            this.advisorClass = this.advisorClass.getSuperclass();
            break;
        }
        this.joinPointArguments = new ArrayList(argumentsSize);
        for (i = 0; i < argumentsSize; ++i) {
            this.joinPointArguments.add(i);
        }
        this.inconsistentTypeArgs = new ThreadLocal<Set<Integer>>(){

            @Override
            protected synchronized Set<Integer> initialValue() {
                return new HashSet<Integer>();
            }
        };
        this.initialiseJoinPointNames();
        this.findAdvisedField(this.advisorClass, info);
    }

    public void rebindJoinpoint(JoinPointInfo newInfo) {
        try {
            if (this.joinpointField == null) {
                return;
            }
            if (this.initialised && this.oldInfo != null && this.oldInfo.equalChains(newInfo)) {
                return;
            }
            this.oldInfo = this.info.copy();
            this.info = newInfo;
            this.joinpointField.set(this.advisor, null);
            if (this.info.getInterceptors() == null) {
                this.generatorField.set(this.advisor, null);
            } else {
                this.generatorField.set(this.advisor, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void generateJoinPointClass() {
        this.generateJoinPointClass(null);
    }

    public synchronized void generateJoinPointClass(ClassLoader classloader) {
        if (System.getSecurityManager() == null) {
            GenerateJoinPointClassAction.NON_PRIVILEGED.generateJoinPointClass(classloader, this);
        } else {
            GenerateJoinPointClassAction.PRIVILEGED.generateJoinPointClass(classloader, this);
        }
    }

    private void doGenerateJoinPointClass(ClassLoader classloader) {
        try {
            if (classloader == null) {
                classloader = Thread.currentThread().getContextClassLoader();
            }
            AspectManager manager = AspectManager.instance();
            ClassPool pool = manager.findClassPool(classloader);
            GeneratedClassInfo generatedClass = this.generateJoinpointClass(pool, this.info);
            ProtectionDomain pd = this.advisorClass.getProtectionDomain();
            Class clazz = this.toClass(pool, generatedClass.getGenerated(), pd);
            Object obj = this.instantiateClass(clazz, generatedClass.getAroundSetups());
            this.joinpointField.set(this.advisor, obj);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating joinpoint class for joinpoint " + this.info, e);
        }
        this.initialised = true;
    }

    private Class toClass(ClassPool pool, CtClass ctclass, ProtectionDomain pd) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        return TransformerCommon.toClass(ctclass, pd);
    }

    private Object instantiateClass(Class clazz, AdviceSetup[] aroundSetups) throws Exception {
        Object obj;
        Constructor ctor = clazz.getConstructor(this.info.getClass());
        try {
            obj = ctor.newInstance(this.info);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            throw new RuntimeException(this.debugClass(sb, clazz).toString());
        }
        for (int i = 0; i < aroundSetups.length; ++i) {
            if (!aroundSetups[i].isNewCFlow()) continue;
            Field field = clazz.getDeclaredField("cflow" + aroundSetups[i].useCFlowFrom());
            field.setAccessible(true);
            field.set(obj, aroundSetups[i].getCFlow());
        }
        return obj;
    }

    private StringBuffer debugClass(StringBuffer sb, Class clazz) {
        sb.append("\n\t\t" + Modifier.toString((int)clazz.getModifiers()) + " " + clazz.getName() + " " + clazz.getClassLoader());
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            sb.append("\n\t\t\t" + Modifier.toString((int)fields[i].getModifiers()) + " " + fields[i].getType().getName() + " " + fields[i].getName() + " " + fields[i].getType().getClassLoader());
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            sb.append("\n\t\t\textends\n");
            this.debugClass(sb, superClass);
        }
        return sb;
    }

    private static synchronized int getIncrement() {
        return ++increment;
    }

    protected abstract void initialiseJoinPointNames();

    private GeneratedClassInfo generateJoinpointClass(ClassPool pool, JoinPointInfo newInfo) throws NotFoundException, CannotCompileException, ClassNotFoundException {
        CtClass superClass = pool.get(this.joinpointFqn);
        String className = this.getJoinpointClassName();
        try {
            CtClass clazz = TransformerCommon.makeClass(pool, className);
            clazz.setSuperclass(superClass);
            JoinPointGenerator.addUntransformableInterface(pool, clazz);
            AdviceSetupsByType setups = this.initialiseAdviceInfosAndAddFields(pool, clazz);
            this.createConstructors(pool, superClass, clazz, setups);
            this.createJoinPointInvokeMethod(superClass, clazz, this.isVoid(), setups);
            this.createInvokeNextMethod(clazz, this.isVoid(), setups.getAroundSetups());
            this.overrideDispatchMethods(superClass, clazz, newInfo);
            return new GeneratedClassInfo(clazz, setups.getAroundSetups());
        }
        catch (NotFoundException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
        catch (CannotCompileException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
        catch (ClassNotFoundException e) {
            System.err.println("Exception generating " + className + ": " + e.getMessage());
            throw e;
        }
    }

    private String getJoinpointClassName() {
        Package pkg = this.advisor.getClass().getPackage();
        StringBuffer className = new StringBuffer();
        if (pkg != null) {
            className.append(pkg.getName());
            className.append(".");
        }
        className.append(this.joinpointClassName);
        className.append("_");
        className.append(JoinPointGenerator.getIncrement());
        return className.toString();
    }

    protected abstract boolean isVoid();

    protected abstract Class getReturnType();

    protected abstract AdviceMethodProperties getAdviceMethodProperties(AdviceSetup var1);

    protected boolean isCaller() {
        return false;
    }

    protected boolean hasCallingObject() {
        return false;
    }

    protected abstract boolean hasTargetObject();

    private boolean isStaticCall() {
        if (this.isCaller()) {
            return !this.hasCallingObject();
        }
        return !this.hasTargetObject();
    }

    private void findAdvisedField(Class advisorSuperClazz, JoinPointInfo info) {
        if (info.getClazz() == null) {
            return;
        }
        while (advisorSuperClazz != null && advisorSuperClazz.getDeclaringClass() != info.getClazz()) {
            advisorSuperClazz = advisorSuperClazz.getSuperclass();
        }
        try {
            this.joinpointField = advisorSuperClazz.getDeclaredField(this.joinpointFieldName);
            SecurityActions.setAccessible(this.joinpointField);
            this.joinpointFqn = advisorSuperClazz.getDeclaringClass().getName() + "$" + this.joinpointClassName;
            try {
                this.generatorField = advisorSuperClazz.getDeclaredField(this.getJoinPointGeneratorFieldName());
                SecurityActions.setAccessible(this.generatorField);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Found joinpoint field " + this.joinpointField.getName() + " in " + advisorSuperClazz.getName() + " but no JoinPointGenerator field called " + this.getJoinPointGeneratorFieldName());
            }
        }
        catch (NoSuchFieldException e) {
            if (!advisorSuperClazz.getName().equals(GENERATED_CLASS_ADVISOR)) {
                this.findAdvisedField(advisorSuperClazz.getSuperclass(), info);
            }
        }
    }

    private AdviceSetupsByType initialiseAdviceInfosAndAddFields(ClassPool pool, CtClass clazz) throws ClassNotFoundException, NotFoundException, CannotCompileException {
        HashMap<String, Integer> cflows = new HashMap<String, Integer>();
        AdviceSetup[] setups = new AdviceSetup[this.info.getInterceptors().length];
        for (int i = 0; i < this.info.getInterceptors().length; ++i) {
            setups[i] = new AdviceSetup(i, (GeneratedAdvisorInterceptor)this.info.getInterceptors()[i]);
            this.addAspectFieldAndGetter(pool, clazz, setups[i]);
            this.addCFlowFieldsAndGetters(pool, setups[i], clazz, cflows);
        }
        return new AdviceSetupsByType(setups);
    }

    private void addAspectFieldAndGetter(ClassPool pool, CtClass clazz, AdviceSetup setup) throws NotFoundException, CannotCompileException {
        CtClass aspectClass = setup.getAspectCtClass();
        if (!setup.shouldInvokeAspect()) {
            return;
        }
        CtField field = new CtField(aspectClass, setup.getAspectFieldName(), clazz);
        field.setModifiers(130);
        clazz.addField(field);
        String body = this.getAspectFieldGetterBody(setup);
        CtMethod method = CtNewMethod.make((CtClass)aspectClass, (String)setup.getAspectInitialiserName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)body, (CtClass)clazz);
        method.setModifiers(2);
        clazz.addMethod(method);
    }

    private String getAspectFieldGetterBody(AdviceSetup setup) {
        if (setup.requiresInstanceAdvisor()) {
            String instanceAdvisor = this.isCaller() ? "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)callingObject)._getInstanceAdvisor();" : "org.jboss.aop.InstanceAdvisor ia = ((org.jboss.aop.Advised)targetObject)._getInstanceAdvisor();";
            return "{   " + instanceAdvisor + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getPerInstanceAspect(info.getAdvisor(), info.getJoinpoint(), ia);" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
        }
        return "{   if (" + setup.getAspectFieldName() + " != null)" + "   {" + "      return " + setup.getAspectFieldName() + ";" + "   }" + "   org.jboss.aop.advice.GeneratedAdvisorInterceptor fw = (org.jboss.aop.advice.GeneratedAdvisorInterceptor)info.getInterceptors()[" + setup.getIndex() + "];" + "   Object o = fw.getAspect(info.getAdvisor(), info.getJoinpoint());" + "   return (" + setup.getAspectClass().getName() + ")o;" + "}";
    }

    private void addCFlowFieldsAndGetters(ClassPool pool, AdviceSetup setup, CtClass clazz, HashMap<String, Integer> cflows) throws NotFoundException, CannotCompileException {
        if (setup.getCFlowString() != null) {
            Integer useCFlowIndex = cflows.get(setup.getCFlowString());
            if (useCFlowIndex == null) {
                useCFlowIndex = new Integer(setup.getIndex());
                cflows.put(setup.getCFlowString(), useCFlowIndex);
                CtField cflowX = new CtField(pool.get(ASTCFlowExpression.class.getName()), "cflow" + useCFlowIndex, clazz);
                clazz.addField(cflowX);
                CtField matchesCFlowX = new CtField(CtClass.booleanType, "matchesCflow" + useCFlowIndex, clazz);
                clazz.addField(matchesCFlowX);
                String initCFlowXBody = "{   org.jboss.aop.pointcut.CFlowMatcher matcher = new org.jboss.aop.pointcut.CFlowMatcher();   return matcher.matches(" + cflowX.getName() + ", this);" + "}";
                CtMethod initCFlowX = CtNewMethod.make((CtClass)CtClass.booleanType, (String)("getCFlow" + useCFlowIndex), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)initCFlowXBody, (CtClass)clazz);
                clazz.addMethod(initCFlowX);
            }
            setup.setUseCFlowFrom(useCFlowIndex);
        }
    }

    private void createJoinPointInvokeMethod(CtClass superClass, CtClass clazz, boolean isVoid, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        CtMethod superInvoke = superClass.getDeclaredMethod(INVOKE_JOINPOINT);
        String code = null;
        try {
            code = this.createJoinpointInvokeBody(clazz, setups, superInvoke.getExceptionTypes(), superInvoke.getParameterTypes());
            CtMethod invoke = CtNewMethod.make((CtClass)superInvoke.getReturnType(), (String)superInvoke.getName(), (CtClass[])superInvoke.getParameterTypes(), (CtClass[])superInvoke.getExceptionTypes(), (String)code, (CtClass)clazz);
            clazz.addMethod(invoke);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error compiling code for Joinpoint (" + this.info.getJoinpoint() + "): " + code + "\n - " + (Object)((Object)e) + "\n - " + JoinPointGenerator.getMethodString(clazz, superInvoke.getName(), superInvoke.getParameterTypes()) + "\n - " + clazz.getName(), e);
        }
    }

    private String createJoinpointInvokeBody(CtClass joinpointClass, AdviceSetupsByType setups, CtClass[] declaredExceptions, CtClass[] parameterTypes) throws NotFoundException {
        StringBuffer code = new StringBuffer();
        code.append("{");
        if (!this.isVoid()) {
            String ret = null;
            Class retType = this.getReturnType();
            if (retType.isPrimitive()) {
                if (retType.equals(Boolean.TYPE)) {
                    ret = "false";
                } else if (retType.equals(Character.TYPE)) {
                    ret = "'\\0'";
                } else if (retType.equals(Byte.TYPE)) {
                    ret = "(byte)0";
                } else if (retType.equals(Short.TYPE)) {
                    ret = "(short)0";
                } else if (retType.equals(Integer.TYPE)) {
                    ret = "(int)0";
                } else if (retType.equals(Long.TYPE)) {
                    ret = "0L";
                } else if (retType.equals(Float.TYPE)) {
                    ret = "0.0f";
                } else if (retType.equals(Double.TYPE)) {
                    ret = "0.0d";
                }
            }
            code.append("   " + ClassExpression.simpleType(this.getReturnType()) + "  " + RETURN_VALUE + " = " + ret + ";");
        }
        code.append("   try");
        code.append("   {");
        boolean argsFoundBefore = DefaultAdviceCallStrategy.getInstance().addInvokeCode(this, setups.getBeforeSetups(), code);
        boolean joinPointCreated = this.addAroundInvokeCode(code, setups, joinpointClass, argsFoundBefore, parameterTypes);
        StringBuffer afterCode = new StringBuffer();
        boolean argsFoundAfter = AfterAdviceCallStrategy.getInstance().addInvokeCode(this, setups.getAfterSetups(), afterCode);
        afterCode.append("   }");
        afterCode.append("   catch(java.lang.Throwable t)");
        afterCode.append("   {");
        boolean bl = argsFoundAfter = DefaultAdviceCallStrategy.getInstance().addInvokeCode(this, setups.getThrowingSetups(), afterCode) || argsFoundAfter;
        if (joinPointCreated && (argsFoundAfter || this.inconsistentTypeArgs.get().size() < this.joinPointArguments.size())) {
            code.append(ARGUMENTS);
            code.append(" = jp.").append(GET_ARGUMENTS).append(";");
            argsFoundAfter = true;
        }
        code.append(afterCode.toString());
        this.addHandleExceptionCode(code, declaredExceptions);
        code.append("   }");
        if (!this.isVoid()) {
            code.append("   return ret;");
        }
        code.append("}");
        if (argsFoundBefore || argsFoundAfter) {
            code.insert(1, this.parameters.declareArgsArray(parameterTypes.length));
        }
        return code.toString();
    }

    private boolean addAroundInvokeCode(StringBuffer code, AdviceSetupsByType setups, CtClass joinpointClass, boolean argsFoundBefore, CtClass[] parameterTypes) throws NotFoundException {
        if (setups.getAroundSetups() != null) {
            StringBuffer aspects = new StringBuffer();
            StringBuffer cflows = new StringBuffer();
            AdviceSetup[] asetups = setups.getAllSetups();
            for (int i = 0; i < asetups.length; ++i) {
                if (!asetups[i].requiresInstanceAdvisor()) {
                    aspects.append(", ");
                    aspects.append(asetups[i].getAspectFieldName());
                }
                if (!asetups[i].isNewCFlow()) continue;
                cflows.append(", cflow" + asetups[i].getIndex());
            }
            code.append(this.joinpointFqn).append(" jp = null;");
            code.append("      if(info.getInterceptors() != null)");
            code.append("      {");
            code.append("         jp = new " + joinpointClass.getName() + "(this");
            if (argsFoundBefore) {
                this.parameters.appendParameterListWithoutArgs(code);
            } else {
                code.append(", $$");
            }
            code.append(aspects.toString() + cflows.toString() + ");");
            if (argsFoundBefore) {
                code.append("   jp.setArguments(");
                code.append(ARGUMENTS);
                code.append(");");
            }
            if (!this.isVoid()) {
                code.append("          ret = ($r)");
            }
            code.append("jp.invokeNext();");
            code.append("      }");
            code.append("      else");
            code.append("      {");
            this.addDispatchCode(code, parameterTypes, argsFoundBefore);
            code.append("      }");
            this.inconsistentTypeArgs.get().addAll(this.joinPointArguments);
            return true;
        }
        this.addDispatchCode(code, parameterTypes, argsFoundBefore);
        return false;
    }

    private final void addDispatchCode(StringBuffer code, CtClass[] parameterTypes, boolean argsFound) {
        if (!this.isVoid()) {
            code.append("          ret = ($r)");
        }
        code.append("super.dispatch(");
        if (argsFound) {
            this.parameters.appendParameterList(code, parameterTypes);
        } else {
            code.append("$$");
        }
        code.append(");");
    }

    private void addHandleExceptionCode(StringBuffer code, CtClass[] declaredExceptions) {
        for (int i = 0; i < declaredExceptions.length; ++i) {
            code.append("if (t instanceof " + declaredExceptions[i].getName() + ")");
            code.append("   throw (" + declaredExceptions[i].getName() + ")t;");
        }
        code.append("if (t instanceof java.lang.RuntimeException)");
        code.append("throw t;");
        code.append("throw new java.lang.RuntimeException(t);");
    }

    private void createInvokeNextMethod(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups) throws NotFoundException, CannotCompileException {
        if (aroundSetups == null) {
            return;
        }
        CtMethod method = jp.getSuperclass().getSuperclass().getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.copy((CtMethod)method, (CtClass)jp, null);
        String code = this.createInvokeNextMethodBody(jp, isVoid, aroundSetups);
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Error creating invokeNext method: " + code, e);
        }
        jp.addMethod(invokeNext);
    }

    private String createInvokeNextMethodBody(CtClass jp, boolean isVoid, AdviceSetup[] aroundSetups) throws NotFoundException {
        String returnStr = isVoid ? "" : "return ($w)";
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   try{");
        body.append("      switch(++super.currentInterceptor){");
        AroundAdviceCallStrategy.getInstance().addInvokeCode(this, aroundSetups, body);
        body.append("      default:");
        body.append("         " + returnStr + "this.dispatch();");
        body.append("      }");
        body.append("   }finally{");
        body.append("      --super.currentInterceptor;");
        body.append("   }");
        body.append("   return null;");
        body.append("}");
        return body.toString();
    }

    private void createConstructors(ClassPool pool, CtClass superClass, CtClass clazz, AdviceSetupsByType setups) throws NotFoundException, CannotCompileException {
        CtConstructor[] superCtors = superClass.getDeclaredConstructors();
        if (superCtors.length != 3 && superCtors.length != 2 && !this.getClass().equals(MethodJoinPointGenerator.class) && !FieldJoinPointGenerator.class.isAssignableFrom(this.getClass())) {
            throw new RuntimeException("JoinPoints should have 2 or 3 constructors, not " + superCtors.length);
        }
        if (superCtors.length != 4 && superCtors.length != 3 && this.getClass().equals(MethodJoinPointGenerator.class)) {
            throw new RuntimeException("Method JoinPoints should have 3 or 4 constructors, not " + superCtors.length);
        }
        int publicIndex = -1;
        int protectedIndex1 = -1;
        int protectedIndex2 = -1;
        int defaultIndex = -1;
        for (int i = 0; i < superCtors.length; ++i) {
            int modifier = superCtors[i].getModifiers();
            if (Modifier.isPublic((int)modifier)) {
                if (superCtors[i].getParameterTypes().length == 0) {
                    defaultIndex = i;
                    continue;
                }
                publicIndex = i;
                continue;
            }
            if (!Modifier.isProtected((int)modifier)) continue;
            if (protectedIndex1 == -1) {
                protectedIndex1 = i;
                continue;
            }
            protectedIndex2 = i;
        }
        if (publicIndex < 0 || protectedIndex1 < 0) {
            throw new RuntimeException("One of the JoinPoint constructors should be public, and at least one of them should be protected");
        }
        if (defaultIndex >= 0) {
            this.createDefaultConstructor(superCtors[defaultIndex], clazz);
        }
        this.createPublicConstructor(superCtors[publicIndex], clazz, setups);
        if (protectedIndex2 == -1) {
            this.createProtectedConstructors(pool, superCtors[protectedIndex1], null, clazz, setups);
        } else {
            this.createProtectedConstructors(pool, superCtors[protectedIndex1], superCtors[protectedIndex2], clazz, setups);
        }
        this.createCopyConstructorAndMethod(pool, clazz);
    }

    private void createDefaultConstructor(CtConstructor superCtor, CtClass clazz) throws CannotCompileException {
        CtConstructor ctor = CtNewConstructor.defaultConstructor((CtClass)clazz);
        clazz.addConstructor(ctor);
    }

    private void createPublicConstructor(CtConstructor superCtor, CtClass clazz, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        StringBuffer body = new StringBuffer();
        try {
            body.append("{super($$);");
            AdviceSetup[] allSetups = setups.getAllSetups();
            for (int i = 0; i < allSetups.length; ++i) {
                if (allSetups[i].requiresInstanceAdvisor()) continue;
                body.append(allSetups[i].getAspectFieldName() + " = " + allSetups[i].getAspectInitialiserName() + "();");
            }
            body.append("}");
            CtConstructor ctor = CtNewConstructor.make((CtClass[])superCtor.getParameterTypes(), (CtClass[])superCtor.getExceptionTypes(), (String)body.toString(), (CtClass)clazz);
            ctor.setModifiers(superCtor.getModifiers());
            clazz.addConstructor(ctor);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException("Error compiling. Code \n" + body.toString(), (Throwable)e);
        }
    }

    private void createProtectedConstructors(ClassPool pool, CtConstructor superCtor1, CtConstructor superCtor2, CtClass clazz, AdviceSetupsByType setups) throws CannotCompileException, NotFoundException {
        ArrayList<AdviceSetup> aspects = new ArrayList<AdviceSetup>();
        ArrayList<Integer> cflows = new ArrayList<Integer>();
        StringBuffer adviceInit = new StringBuffer();
        AdviceSetup[] allSetups = setups.getAllSetups();
        for (int i = 0; i < allSetups.length; ++i) {
            if (!allSetups[i].shouldInvokeAspect()) continue;
            if (allSetups[i].requiresInstanceAdvisor()) {
                adviceInit.append(allSetups[i].getAspectFieldName());
                adviceInit.append(" = ");
                adviceInit.append(allSetups[i].getAspectInitialiserName());
                adviceInit.append("();");
            } else {
                aspects.add(allSetups[i]);
            }
            if (!allSetups[i].isNewCFlow()) continue;
            cflows.add(allSetups[i].useCFlowFrom());
        }
        this.createProtectedConstructor(pool, clazz, superCtor1, allSetups, aspects, cflows, adviceInit.toString());
        if (superCtor2 != null) {
            this.createProtectedConstructor(pool, clazz, superCtor2, allSetups, aspects, cflows, adviceInit.toString());
        }
    }

    private void createProtectedConstructor(ClassPool pool, CtClass clazz, CtConstructor superCtor, AdviceSetup[] allSetups, ArrayList<AdviceSetup> aspects, ArrayList<Integer> cflows, String aspectInitialization) throws NotFoundException, CannotCompileException {
        int i;
        CtClass[] superParams = superCtor.getParameterTypes();
        CtClass[] params = new CtClass[superParams.length + aspects.size() + cflows.size()];
        System.arraycopy(superParams, 0, params, 0, superParams.length);
        StringBuffer init = new StringBuffer();
        for (int i2 = 0; i2 < aspects.size(); ++i2) {
            AdviceSetup setup = aspects.get(i2);
            params[i2 + superParams.length] = setup.getAspectCtClass();
            init.append("this." + setup.getAspectFieldName() + " = $" + (i2 + superParams.length + 1) + ";");
        }
        int aspectsLength = superParams.length + aspects.size();
        if (cflows.size() > 0) {
            CtClass astCFlowExpr = pool.get(ASTCFlowExpression.class.getName());
            for (i = 0; i < cflows.size(); ++i) {
                params[i + aspectsLength] = astCFlowExpr;
                init.append("cflow" + cflows.get(i) + "= $" + (i + aspectsLength + 1) + ";");
                init.append("matchesCflow" + cflows.get(i) + " = getCFlow" + allSetups[cflows.get(i)].useCFlowFrom() + "();");
            }
        }
        StringBuffer body = new StringBuffer("{super(");
        for (i = 0; i < superParams.length; ++i) {
            if (i > 0) {
                body.append(", ");
            }
            body.append("$" + (i + 1));
        }
        body.append(");");
        body.append(aspectInitialization);
        body.append(init.toString());
        body.append("}");
        CtConstructor ctor = CtNewConstructor.make((CtClass[])params, (CtClass[])superCtor.getExceptionTypes(), (String)body.toString(), (CtClass)clazz);
        ctor.setModifiers(superCtor.getModifiers());
        clazz.addConstructor(ctor);
    }

    private void createCopyConstructorAndMethod(ClassPool pool, CtClass clazz) throws NotFoundException, CannotCompileException {
        StringBuffer body = new StringBuffer();
        body.append("{");
        body.append("   super($1.info);");
        for (CtClass superClass = clazz; superClass != null && !superClass.getName().equals("java.lang.Object"); superClass = superClass.getSuperclass()) {
            CtField[] fields = superClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isPrivate((int)fields[i].getModifiers()) && fields[i].getDeclaringClass() != clazz || Modifier.isFinal((int)fields[i].getModifiers()) || Modifier.isStatic((int)fields[i].getModifiers())) continue;
                body.append("   this." + fields[i].getName() + " = $1." + fields[i].getName() + ";");
            }
        }
        body.append("}");
        CtConstructor copyCtor = CtNewConstructor.make((CtClass[])new CtClass[]{clazz}, (CtClass[])new CtClass[0], (String)body.toString(), (CtClass)clazz);
        copyCtor.setModifiers(2);
        clazz.addConstructor(copyCtor);
        CtMethod superCopy = pool.get(Invocation.class.getName()).getDeclaredMethod("copy");
        String copyBody = "{   return new " + clazz.getName() + "(this);" + "}";
        CtMethod copy = CtNewMethod.make((CtClass)superCopy.getReturnType(), (String)superCopy.getName(), (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)copyBody, (CtClass)clazz);
        clazz.setModifiers(1);
        clazz.addMethod(copy);
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, JoinPointInfo newInfo) throws CannotCompileException, NotFoundException {
    }

    protected void overrideDispatchMethods(CtClass superClass, CtClass clazz, CallerConstructorInfo cinfo) throws NotFoundException, CannotCompileException {
        if (cinfo.getWrappingMethod() == null) {
            return;
        }
        CtMethod[] superDispatches = JavassistUtils.getDeclaredMethodsWithName(superClass, DISPATCH);
        if (superDispatches.length > 2 && AspectManager.verbose) {
            System.out.println("[warn] - Too many dispatch() methods found in " + superClass.getName());
        }
        for (int i = 0; i < superDispatches.length; ++i) {
            CtMethod wrapperMethod = ReflectToJavassist.methodToJavassist(cinfo.getWrappingMethod());
            CtClass[] params = wrapperMethod.getParameterTypes();
            StringBuffer parameters = new StringBuffer("(");
            if (superDispatches[i].getParameterTypes().length == 0) {
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("arg" + j);
                }
            } else {
                int offset = this.hasCallingObject() ? 1 : 0;
                for (int j = 0; j < params.length; ++j) {
                    if (j > 0) {
                        parameters.append(", ");
                    }
                    parameters.append("$" + (j + offset + 1));
                }
            }
            parameters.append(")");
            String body = "{ return " + cinfo.getConstructor().getDeclaringClass().getName() + "." + cinfo.getWrappingMethod().getName() + parameters + ";}";
            try {
                CtMethod dispatch = CtNewMethod.make((CtClass)superDispatches[i].getReturnType(), (String)superDispatches[i].getName(), (CtClass[])superDispatches[i].getParameterTypes(), (CtClass[])superDispatches[i].getExceptionTypes(), (String)body, (CtClass)clazz);
                dispatch.setModifiers(superDispatches[i].getModifiers());
                clazz.addMethod(dispatch);
                continue;
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + JoinPointGenerator.getMethodString(clazz, superDispatches[i].getName(), superDispatches[i].getParameterTypes()), e);
            }
        }
    }

    protected static void addUntransformableInterface(Instrumentor instrumentor, CtClass clazz) throws NotFoundException {
        JoinPointGenerator.addUntransformableInterface(instrumentor.getClassPool(), clazz);
    }

    protected static void addUntransformableInterface(ClassPool pool, CtClass clazz) throws NotFoundException {
        CtClass untransformable = pool.get(Untransformable.class.getName());
        clazz.addInterface(untransformable);
    }

    protected abstract String getJoinPointGeneratorFieldName();

    protected static String getMethodString(CtClass joinpoint, String method, CtClass[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(joinpoint);
        sb.append(".");
        sb.append("name");
        sb.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(params[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }

    private static class AfterAdviceCallStrategy
    extends AdviceCallStrategy {
        private static AfterAdviceCallStrategy INSTANCE = new AfterAdviceCallStrategy();

        public static final AfterAdviceCallStrategy getInstance() {
            return INSTANCE;
        }

        private AfterAdviceCallStrategy() {
        }

        public String generateKey(JoinPointGenerator generator) {
            if (generator.isVoid()) {
                return "";
            }
            return "          ret = (" + generator.getReturnType().getName() + ")";
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator) throws NotFoundException {
            AdviceMethodProperties properties = setup.getAdviceMethodProperties();
            if (properties != null && !properties.isAdviceVoid()) {
                call.append(key);
            }
            return ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, false, generator);
        }
    }

    private static class DefaultAdviceCallStrategy
    extends AdviceCallStrategy {
        private static DefaultAdviceCallStrategy INSTANCE = new DefaultAdviceCallStrategy();

        public static final DefaultAdviceCallStrategy getInstance() {
            return INSTANCE;
        }

        private DefaultAdviceCallStrategy() {
        }

        public String generateKey(JoinPointGenerator generator) {
            return null;
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator) {
            return ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, false, generator);
        }
    }

    private static class AroundAdviceCallStrategy
    extends AdviceCallStrategy {
        private static ThreadLocal<AroundAdviceCallStrategy> INSTANCE = new ThreadLocal<AroundAdviceCallStrategy>(){

            @Override
            protected synchronized AroundAdviceCallStrategy initialValue() {
                return new AroundAdviceCallStrategy();
            }
        };
        private int addedAdvice = 0;
        private boolean consistencyEnforced = false;

        public static final AroundAdviceCallStrategy getInstance() {
            return INSTANCE.get();
        }

        private AroundAdviceCallStrategy() {
        }

        public String generateKey(JoinPointGenerator generator) {
            this.addedAdvice = 0;
            if (generator.isVoid()) {
                return "";
            }
            return "return ($w)";
        }

        public boolean appendAdviceCall(AdviceSetup setup, String key, StringBuffer beforeCall, StringBuffer call, JoinPointGenerator generator) {
            if (!setup.shouldInvokeAspect()) {
                return false;
            }
            boolean result = false;
            AdviceMethodProperties properties = AdviceMethodFactory.AROUND.findAdviceMethod(generator.getAdviceMethodProperties(setup));
            if (properties == null || properties.getAdviceMethod() == null) {
                return false;
            }
            beforeCall.append("      case ");
            beforeCall.append(++this.addedAdvice);
            beforeCall.append(":");
            if (setup.getCFlowString() != null) {
                beforeCall.append("         if (matchesCflow" + setup.useCFlowFrom() + ")");
                beforeCall.append("         {");
                result = this.appendAroundCallString(beforeCall, call, key, setup, properties, generator);
                call.append("         }");
                call.append("         else");
                call.append("         {");
                call.append("            ");
                call.append(key);
                call.append(" invokeNext();");
                call.append("         }");
            } else {
                result = this.appendAroundCallString(beforeCall, call, key, setup, properties, generator);
            }
            call.append("      break;");
            return result;
        }

        public boolean appendAroundCallString(StringBuffer beforeCall, StringBuffer call, String returnStr, AdviceSetup setup, AdviceMethodProperties properties, JoinPointGenerator generator) {
            boolean firstParamIsInvocation;
            this.consistencyEnforced = false;
            int[] args = properties.getArgs();
            boolean bl = firstParamIsInvocation = args.length >= 1 && args[0] == -2;
            if (!firstParamIsInvocation) {
                call.append("try{");
                call.append("   org.jboss.aop.joinpoint.CurrentInvocation.push(this); ");
            }
            call.append("   ");
            call.append(returnStr);
            call.append(" ");
            boolean result = ((AdviceCallStrategy)this).appendAdviceCall(setup, beforeCall, call, true, generator);
            if (!firstParamIsInvocation) {
                call.append("}finally{");
                call.append("   org.jboss.aop.joinpoint.CurrentInvocation.pop(); ");
                call.append("}");
            }
            return result;
        }

        protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator) {
            switch (arg) {
                case -3: {
                    if (!generator.parameters.hasTarget()) break;
                    call.append(JoinPointGenerator.TARGET_FIELD);
                    return false;
                }
                case -7: {
                    if (!generator.parameters.hasCaller()) break;
                    call.append(JoinPointGenerator.CALLER_FIELD);
                    return false;
                }
                case -6: {
                    call.append(JoinPointGenerator.GET_ARGUMENTS);
                    return true;
                }
            }
            if (arg >= 0) {
                if (!this.consistencyEnforced) {
                    beforeCall.append("enforceArgsConsistency");
                    beforeCall.append("();");
                    this.consistencyEnforced = true;
                }
                call.append("this.arg");
                call.append(arg);
                return false;
            }
            return super.appendParameter(beforeCall, call, arg, adviceParam, properties, generator);
        }
    }

    private static abstract class AdviceCallStrategy {
        private AdviceCallStrategy() {
        }

        public boolean addInvokeCode(JoinPointGenerator generator, AdviceSetup[] setups, StringBuffer code) throws NotFoundException {
            StringBuffer call = new StringBuffer();
            if (setups == null || setups.length == 0) {
                return false;
            }
            boolean argsFound = false;
            String key = this.generateKey(generator);
            for (int i = 0; i < setups.length; ++i) {
                call.setLength(0);
                argsFound = this.appendAdviceCall(setups[i], key, code, call, generator) || argsFound;
                code.append(call);
                call.setLength(0);
            }
            return argsFound;
        }

        protected abstract String generateKey(JoinPointGenerator var1);

        protected abstract boolean appendAdviceCall(AdviceSetup var1, String var2, StringBuffer var3, StringBuffer var4, JoinPointGenerator var5) throws NotFoundException;

        private final boolean appendAdviceCall(AdviceSetup setup, StringBuffer beforeCall, StringBuffer call, boolean isAround, JoinPointGenerator generator) {
            AdviceMethodProperties properties = setup.getAdviceMethodProperties();
            if (properties == null) {
                return false;
            }
            call.append(setup.getAspectFieldName());
            call.append(".");
            call.append(setup.getAdviceName());
            call.append("(");
            int[] args = properties.getArgs();
            boolean argsFound = false;
            if (args.length > 0) {
                Class<?>[] adviceParams = properties.getAdviceMethod().getParameterTypes();
                call.append("(");
                call.append(ClassExpression.simpleType(adviceParams[0]));
                call.append(")");
                argsFound = this.appendParameter(beforeCall, call, args[0], adviceParams[0], properties, generator);
                for (int i = 1; i < args.length; ++i) {
                    call.append(", (");
                    call.append(ClassExpression.simpleType(adviceParams[i]));
                    call.append(")");
                    argsFound = this.appendParameter(beforeCall, call, args[i], adviceParams[i], properties, generator) || argsFound;
                }
            }
            call.append(");");
            return argsFound;
        }

        protected boolean appendParameter(StringBuffer beforeCall, StringBuffer call, int arg, Class adviceParam, AdviceMethodProperties properties, JoinPointGenerator generator) {
            switch (arg) {
                case -2: {
                    call.append("this");
                    break;
                }
                case -1: {
                    call.append(JoinPointGenerator.INFO_FIELD);
                    break;
                }
                case -4: {
                    call.append(JoinPointGenerator.RETURN_VALUE);
                    break;
                }
                case -5: {
                    call.append(JoinPointGenerator.THROWABLE);
                    break;
                }
                case -3: {
                    if (!generator.parameters.hasTarget()) {
                        call.append("null");
                        break;
                    }
                    call.append('$');
                    call.append(generator.parameters.getTargetIndex());
                    break;
                }
                case -7: {
                    if (!generator.parameters.hasCaller()) {
                        call.append("null");
                        break;
                    }
                    call.append('$');
                    call.append(generator.parameters.getCallerIndex());
                    break;
                }
                case -6: {
                    call.append(JoinPointGenerator.ARGUMENTS);
                    ((Set)generator.inconsistentTypeArgs.get()).addAll(generator.joinPointArguments);
                    return true;
                }
                default: {
                    Set inconsistentTypeArgs = (Set)generator.inconsistentTypeArgs.get();
                    int argIndex = arg + generator.parameters.getFirstArgIndex();
                    if (inconsistentTypeArgs.contains(arg)) {
                        beforeCall.append("$").append(argIndex).append(" = ");
                        beforeCall.append(ReflectToJavassist.castInvocationValueToTypeString(properties.getJoinpointParameters()[arg], "arguments[" + arg + ']'));
                        beforeCall.append(';');
                        inconsistentTypeArgs.remove(arg);
                    }
                    call.append("$");
                    call.append(arg + generator.parameters.getFirstArgIndex());
                }
            }
            return false;
        }
    }

    private static interface GenerateJoinPointClassAction {
        public static final GenerateJoinPointClassAction PRIVILEGED = new GenerateJoinPointClassAction(){

            public void generateJoinPointClass(final ClassLoader classloader, final JoinPointGenerator joinPointGenerator) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            joinPointGenerator.doGenerateJoinPointClass(classloader);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception actual = e.getException();
                    if (actual instanceof RuntimeException) {
                        throw (RuntimeException)actual;
                    }
                    throw new RuntimeException(actual);
                }
            }
        };
        public static final GenerateJoinPointClassAction NON_PRIVILEGED = new GenerateJoinPointClassAction(){

            public void generateJoinPointClass(ClassLoader classloader, JoinPointGenerator joinPointGenerator) {
                joinPointGenerator.doGenerateJoinPointClass(classloader);
            }
        };

        public void generateJoinPointClass(ClassLoader var1, JoinPointGenerator var2);
    }

    private class AdviceSetupsByType {
        AdviceSetup[] allSetups;
        AdviceSetup[] beforeSetups;
        AdviceSetup[] afterSetups;
        AdviceSetup[] throwingSetups;
        AdviceSetup[] aroundSetups;

        AdviceSetupsByType(AdviceSetup[] setups) {
            this.allSetups = setups;
            ArrayList<AdviceSetup> beforeAspects = null;
            ArrayList<AdviceSetup> afterAspects = null;
            ArrayList<AdviceSetup> throwingAspects = null;
            ArrayList<AdviceSetup> aroundAspects = null;
            for (int i = 0; i < setups.length; ++i) {
                AdviceMethodProperties properties;
                if (setups[i].isBefore()) {
                    if (beforeAspects == null) {
                        beforeAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.BEFORE.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        beforeAspects.add(setups[i]);
                        continue;
                    }
                } else if (setups[i].isAfter()) {
                    if (afterAspects == null) {
                        afterAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.AFTER.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        afterAspects.add(setups[i]);
                        continue;
                    }
                } else if (setups[i].isThrowing()) {
                    if (throwingAspects == null) {
                        throwingAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.THROWING.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        throwingAspects.add(setups[i]);
                        continue;
                    }
                } else {
                    if (aroundAspects == null) {
                        aroundAspects = new ArrayList<AdviceSetup>();
                    }
                    if ((properties = AdviceMethodFactory.AROUND.findAdviceMethod(JoinPointGenerator.this.getAdviceMethodProperties(setups[i]))) != null) {
                        setups[i].setAdviceMethodProperties(properties);
                        aroundAspects.add(setups[i]);
                        continue;
                    }
                }
                if (!AspectManager.verbose) continue;
                System.out.print("[warn] No matching advice called '" + setups[i].getAdviceName() + "' could be found in " + setups[i].getAspectClass().getName() + " for joinpoint " + JoinPointGenerator.this.info + ":");
                System.out.println(AdviceMethodFactory.getAdviceMatchingMessage());
            }
            this.beforeSetups = beforeAspects == null ? null : beforeAspects.toArray(new AdviceSetup[beforeAspects.size()]);
            this.afterSetups = afterAspects == null ? null : afterAspects.toArray(new AdviceSetup[afterAspects.size()]);
            this.throwingSetups = throwingAspects == null ? null : throwingAspects.toArray(new AdviceSetup[throwingAspects.size()]);
            this.aroundSetups = aroundAspects == null ? null : aroundAspects.toArray(new AdviceSetup[aroundAspects.size()]);
        }

        public AdviceSetup[] getAllSetups() {
            return this.allSetups;
        }

        public AdviceSetup[] getAfterSetups() {
            return this.afterSetups;
        }

        public AdviceSetup[] getAroundSetups() {
            return this.aroundSetups;
        }

        public AdviceSetup[] getBeforeSetups() {
            return this.beforeSetups;
        }

        public AdviceSetup[] getThrowingSetups() {
            return this.throwingSetups;
        }
    }

    private class GeneratedClassInfo {
        CtClass generated;
        AdviceSetup[] aroundSetups;

        GeneratedClassInfo(CtClass generated, AdviceSetup[] aroundSetups) {
            this.generated = generated;
            this.aroundSetups = aroundSetups;
        }

        CtClass getGenerated() {
            return this.generated;
        }

        AdviceSetup[] getAroundSetups() {
            return this.aroundSetups == null ? new AdviceSetup[]{} : this.aroundSetups;
        }
    }

    protected class AdviceSetup {
        int index;
        Class aspectClass;
        CtClass aspectCtClass;
        String adviceName;
        Scope scope;
        String registeredName;
        String cflowString;
        ASTCFlowExpression cflowExpr;
        int cflowIndex;
        boolean isBefore;
        boolean isAfter;
        boolean isThrowing;
        AdviceMethodProperties adviceMethodProperties;

        AdviceSetup(int index, GeneratedAdvisorInterceptor ifw) throws ClassNotFoundException, NotFoundException {
            this.index = index;
            this.scope = ifw.getScope();
            this.adviceName = ifw.getAdviceName();
            this.registeredName = ifw.getRegisteredName();
            this.cflowString = ifw.getCFlowString();
            this.cflowExpr = ifw.getCflowExpression();
            if (ifw.isAspectFactory()) {
                Object aspectInstance = ((GeneratedAdvisorInterceptor)JoinPointGenerator.this.info.getInterceptors()[index]).getAspect(JoinPointGenerator.this.info.getAdvisor(), JoinPointGenerator.this.info.getJoinpoint(), true);
                this.aspectClass = aspectInstance.getClass();
            } else {
                this.aspectClass = Thread.currentThread().getContextClassLoader().loadClass(ifw.getAspectClassName());
            }
            this.aspectCtClass = ReflectToJavassist.classToJavassist(this.aspectClass);
            this.isBefore = ifw.isBefore();
            this.isAfter = ifw.isAfter();
            this.isThrowing = ifw.isThrowing();
        }

        String getAdviceName() {
            return this.adviceName;
        }

        Class getAspectClass() {
            return this.aspectClass;
        }

        CtClass getAspectCtClass() {
            return this.aspectCtClass;
        }

        Scope getScope() {
            return this.scope;
        }

        int getIndex() {
            return this.index;
        }

        String getRegisteredName() {
            return this.registeredName;
        }

        String getAspectFieldName() {
            StringBuffer name = new StringBuffer();
            if (this.isAround()) {
                name.append("around");
            } else if (this.isBefore()) {
                name.append("before");
            } else if (this.isAfter()) {
                name.append("after");
            } else if (this.isThrowing()) {
                name.append("throwing");
            } else if (AspectManager.verbose) {
                System.out.println("[warn] Unsupported type of advice");
            }
            name.append(this.index + 1);
            return name.toString();
        }

        String getAspectInitialiserName() {
            StringBuffer name = new StringBuffer();
            if (this.isAround()) {
                name.append("getAround");
            } else if (this.isBefore()) {
                name.append("getBefore");
            } else if (this.isAfter()) {
                name.append("getAfter");
            } else if (this.isThrowing()) {
                name.append("getThrowing");
            } else if (AspectManager.verbose) {
                System.out.println("[warn] Unsupported type of advice");
            }
            name.append(this.index + 1);
            return name.toString();
        }

        boolean isPerInstance() {
            return this.scope == Scope.PER_INSTANCE;
        }

        boolean isPerJoinpoint() {
            return this.scope == Scope.PER_JOINPOINT;
        }

        boolean shouldInvokeAspect() {
            return !this.isPerInstance() || !JoinPointGenerator.this.isStaticCall();
        }

        boolean requiresInstanceAdvisor() {
            return this.isPerInstance() || this.isPerJoinpoint() && !JoinPointGenerator.this.isStaticCall();
        }

        String getCFlowString() {
            return this.cflowString;
        }

        ASTCFlowExpression getCFlow() {
            return this.cflowExpr;
        }

        void setUseCFlowFrom(int index) {
            this.cflowIndex = index;
        }

        int useCFlowFrom() {
            return this.cflowIndex;
        }

        boolean isNewCFlow() {
            return this.getCFlowString() != null && this.index == this.cflowIndex;
        }

        boolean isAfter() {
            return this.isAfter;
        }

        boolean isBefore() {
            return this.isBefore;
        }

        boolean isThrowing() {
            return this.isThrowing;
        }

        boolean isAround() {
            return !this.isAfter && !this.isBefore && !this.isThrowing;
        }

        public AdviceMethodProperties getAdviceMethodProperties() {
            return this.adviceMethodProperties;
        }

        public void setAdviceMethodProperties(AdviceMethodProperties adviceMethodProperties) {
            this.adviceMethodProperties = adviceMethodProperties;
        }
    }

    protected static class JoinPointParameters {
        public static final JoinPointParameters ONLY_ARGS = new JoinPointParameters(false, -1, false, -1, 0, null);
        public static final JoinPointParameters TARGET_ARGS = new JoinPointParameters(true, 1, false, -1, 1, "$1");
        public static final JoinPointParameters CALLER_ARGS = new JoinPointParameters(false, -1, true, 1, 1, "$1");
        public static final JoinPointParameters TARGET_CALLER_ARGS = new JoinPointParameters(true, 1, true, 2, 2, "$1, $2");
        private boolean target;
        private boolean caller;
        private int targetIndex;
        private int callerIndex;
        private int firstArgIndex;
        private String targetCallerList;
        private static final String[][] primitiveExtractions = new String[][]{{"((Boolean) arguments [", "]).booleanValue()"}, {"((Integer) arguments[", "]).intValue()"}, {"((Double) arguments[", "]).doubleValue()"}, {"((Float) arguments[", "]).floatValue()"}, {"((Character) arguments[", "]).charValue()"}, {"((Byte) arguments [", "]).byteValue()"}, {"((Long) arguments[", "]).longValue()"}, {"((Short) arguments[", "]).shortValue()"}};

        private JoinPointParameters(boolean target, int targetIndex, boolean caller, int callerIndex, int firstArgIndex, String targetCallerList) {
            this.target = target;
            this.targetIndex = targetIndex;
            this.caller = caller;
            this.callerIndex = callerIndex;
            this.firstArgIndex = firstArgIndex + 1;
            this.targetCallerList = targetCallerList;
        }

        public final boolean hasTarget() {
            return this.target;
        }

        public final int getTargetIndex() {
            return this.targetIndex;
        }

        public final boolean hasCaller() {
            return this.caller;
        }

        public final int getCallerIndex() {
            return this.callerIndex;
        }

        public final int getFirstArgIndex() {
            return this.firstArgIndex;
        }

        public final String declareArgsArray(int totalParameters) {
            StringBuffer buffer = new StringBuffer("Object[] ");
            buffer.append(JoinPointGenerator.ARGUMENTS);
            if (++totalParameters == this.firstArgIndex) {
                buffer.append(" = new Object[0];");
            } else {
                buffer.append(" = new Object[]{($w)$");
                buffer.append(this.firstArgIndex);
                for (int i = this.firstArgIndex + 1; i < totalParameters; ++i) {
                    buffer.append(", ($w)$");
                    buffer.append(i);
                }
                buffer.append("};");
            }
            return buffer.toString();
        }

        public final void appendParameterList(StringBuffer code, CtClass[] parameterTypes) {
            int j = this.firstArgIndex - 1;
            int totalParameters = parameterTypes.length - j;
            if (this.targetCallerList != null) {
                code.append(this.targetCallerList);
            }
            if (totalParameters == 0) {
                return;
            }
            if (this.targetCallerList != null) {
                code.append(", ");
            }
            this.castArgument(code, parameterTypes[j++], 0);
            int i = 1;
            while (i < totalParameters) {
                code.append(", ");
                this.castArgument(code, parameterTypes[j], i);
                ++i;
                ++j;
            }
        }

        public final void appendParameterListWithoutArgs(StringBuffer code) {
            if (this.targetCallerList != null) {
                code.append(',');
                code.append(this.targetCallerList);
            }
        }

        public final void castArgument(StringBuffer code, CtClass expectedType, int i) {
            if (expectedType.isPrimitive()) {
                String[] extraction = null;
                if (expectedType == CtClass.booleanType) {
                    extraction = primitiveExtractions[0];
                } else if (expectedType == CtClass.intType) {
                    extraction = primitiveExtractions[1];
                } else if (expectedType == CtClass.doubleType) {
                    extraction = primitiveExtractions[2];
                } else if (expectedType == CtClass.floatType) {
                    extraction = primitiveExtractions[3];
                } else if (expectedType == CtClass.charType) {
                    extraction = primitiveExtractions[4];
                } else if (expectedType == CtClass.byteType) {
                    extraction = primitiveExtractions[5];
                } else if (expectedType == CtClass.longType) {
                    extraction = primitiveExtractions[6];
                } else if (expectedType == CtClass.shortType) {
                    extraction = primitiveExtractions[7];
                }
                code.append(extraction[0]);
                code.append(i);
                code.append(extraction[1]);
            } else {
                code.append("(");
                code.append(expectedType.getName());
                code.append(") ");
                code.append(JoinPointGenerator.ARGUMENTS);
                code.append("[");
                code.append(i);
                code.append("]");
            }
        }
    }
}

