/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.spi.builder;

import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.builder.AbstractInstallMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.CreateLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.DestroyLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.InstallMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.LifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.ParameterMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.StartLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.StopLifecycleMetaDataBuilder;
import org.jboss.beans.metadata.plugins.builder.UninstallMetaDataBuilder;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.spi.ControllerMode;

public class BeanMetaDataBuilder {
    private AbstractBeanMetaData beanMetaData;
    private ParameterMetaDataBuilder<AbstractConstructorMetaData> constructorBuilder;
    private LifecycleMetaDataBuilder createBuilder;
    private LifecycleMetaDataBuilder startBuilder;
    private LifecycleMetaDataBuilder stopBuilder;
    private LifecycleMetaDataBuilder destroyBuilder;
    private AbstractInstallMetaDataBuilder installBuilder;
    private AbstractInstallMetaDataBuilder uninstallBuilder;

    public BeanMetaDataBuilder(String bean) {
        this(new AbstractBeanMetaData(bean));
    }

    public BeanMetaDataBuilder(String name, String bean) {
        this(new AbstractBeanMetaData(name, bean));
    }

    public BeanMetaDataBuilder(AbstractBeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
        this.createBuilder = new CreateLifecycleMetaDataBuilder(beanMetaData);
        this.startBuilder = new StartLifecycleMetaDataBuilder(beanMetaData);
        this.stopBuilder = new StopLifecycleMetaDataBuilder(beanMetaData);
        this.destroyBuilder = new DestroyLifecycleMetaDataBuilder(beanMetaData);
        this.installBuilder = new InstallMetaDataBuilder(beanMetaData);
        this.uninstallBuilder = new UninstallMetaDataBuilder(beanMetaData);
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public BeanMetaDataBuilder setMode(String modeString) {
        return this.setMode(new ControllerMode(modeString));
    }

    public BeanMetaDataBuilder setMode(ControllerMode mode) {
        this.beanMetaData.setMode(mode);
        return this;
    }

    public BeanMetaDataBuilder setClassLoader(Object classLoader) {
        this.beanMetaData.setClassLoader(new AbstractClassLoaderMetaData(new AbstractValueMetaData(classLoader)));
        return this;
    }

    public BeanMetaDataBuilder addConstructorParameter(String type, Object value) {
        AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)this.beanMetaData.getConstructor();
        if (constructor == null) {
            constructor = new AbstractConstructorMetaData();
            this.beanMetaData.setConstructor(constructor);
            this.constructorBuilder = new ParameterMetaDataBuilder<AbstractConstructorMetaData>(constructor);
        }
        this.constructorBuilder.addParameterMetaData(type, value);
        return this;
    }

    public BeanMetaDataBuilder addPropertyMetaData(String name, Object value) {
        Set<PropertyMetaData> properties = this.beanMetaData.getProperties();
        if (properties == null) {
            properties = new HashSet<PropertyMetaData>();
            this.beanMetaData.setProperties(properties);
        }
        properties.add(new AbstractPropertyMetaData(name, value));
        return this;
    }

    public BeanMetaDataBuilder setCreate(String methodName) {
        this.createBuilder.createLifecycleMetaData(methodName);
        return this;
    }

    public BeanMetaDataBuilder addCreateParameter(String type, Object value) {
        this.createBuilder.addParameterMetaData(type, value);
        return this;
    }

    public BeanMetaDataBuilder setStart(String methodName) {
        this.startBuilder.createLifecycleMetaData(methodName);
        return this;
    }

    public BeanMetaDataBuilder addStartParameter(String type, Object value) {
        this.startBuilder.addParameterMetaData(type, value);
        return this;
    }

    public BeanMetaDataBuilder setStop(String methodName) {
        this.stopBuilder.createLifecycleMetaData(methodName);
        return this;
    }

    public BeanMetaDataBuilder addStopParameter(String type, Object value) {
        this.stopBuilder.addParameterMetaData(type, value);
        return this;
    }

    public BeanMetaDataBuilder setDestroy(String methodName) {
        this.destroyBuilder.createLifecycleMetaData(methodName);
        return this;
    }

    public BeanMetaDataBuilder addDestroyParameter(String type, Object value) {
        this.destroyBuilder.addParameterMetaData(type, value);
        return this;
    }

    public BeanMetaDataBuilder addSupply(Object supply) {
        Set<SupplyMetaData> supplies = this.beanMetaData.getSupplies();
        if (supplies == null) {
            supplies = new HashSet<SupplyMetaData>();
            this.beanMetaData.setSupplies(supplies);
        }
        supplies.add(new AbstractSupplyMetaData(supply));
        return this;
    }

    public BeanMetaDataBuilder addDemand(Object demand) {
        Set<DemandMetaData> demands = this.beanMetaData.getDemands();
        if (demands == null) {
            demands = new HashSet<DemandMetaData>();
            this.beanMetaData.setDemands(demands);
        }
        demands.add(new AbstractDemandMetaData(demand));
        return this;
    }

    public BeanMetaDataBuilder addDependency(Object dependency) {
        Set<DependencyMetaData> dependencies = this.beanMetaData.getDepends();
        if (dependencies == null) {
            dependencies = new HashSet<DependencyMetaData>();
            this.beanMetaData.setDepends(dependencies);
        }
        dependencies.add(new AbstractDependencyMetaData(dependency));
        return this;
    }

    public BeanMetaDataBuilder addInstall(String methodName) {
        return this.addInstall(methodName, null);
    }

    public BeanMetaDataBuilder addInstall(String methodName, String bean) {
        return this.addInstall(methodName, bean, new String[0], new Object[0]);
    }

    public BeanMetaDataBuilder addInstall(String methodName, String type, Object value) {
        return this.addInstall(methodName, null, type, value);
    }

    public BeanMetaDataBuilder addInstall(String methodName, String bean, String type, Object value) {
        return this.addInstall(methodName, bean, new String[]{type}, new Object[]{value});
    }

    public BeanMetaDataBuilder addInstall(String methodName, String[] types, Object[] values) {
        return this.addInstall(methodName, null, types, values);
    }

    public BeanMetaDataBuilder addInstall(String methodName, String bean, String[] types, Object[] values) {
        AbstractInstallMetaData install = (AbstractInstallMetaData)this.installBuilder.createLifecycleMetaData(methodName);
        install.setBean(bean);
        for (int i = 0; i < types.length; ++i) {
            this.installBuilder.addParameter(install, types[i], values[i]);
        }
        return this;
    }

    public BeanMetaDataBuilder addUninstall(String methodName) {
        return this.addUninstall(methodName, null);
    }

    public BeanMetaDataBuilder addUninstall(String methodName, String type, Object value) {
        return this.addUninstall(methodName, new String[]{type}, new Object[]{value});
    }

    public BeanMetaDataBuilder addUninstall(String methodName, String[] types, Object[] values) {
        return this.addUninstall(methodName, null, types, values);
    }

    public BeanMetaDataBuilder addUninstall(String methodName, String bean) {
        return this.addUninstall(methodName, bean, new String[0], new Object[0]);
    }

    public BeanMetaDataBuilder addUninstall(String methodName, String bean, String type, Object value) {
        return this.addUninstall(methodName, bean, new String[]{type}, new Object[]{value});
    }

    public BeanMetaDataBuilder addUninstall(String methodName, String bean, String[] types, Object[] values) {
        AbstractInstallMetaData uninstall = (AbstractInstallMetaData)this.uninstallBuilder.createLifecycleMetaData(methodName);
        uninstall.setBean(bean);
        for (int i = 0; i < types.length; ++i) {
            this.uninstallBuilder.addParameter(uninstall, types[i], values[i]);
        }
        return this;
    }
}

