/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.deployers.plugins.deployers.helpers.AbstractParsingDeployer;
import org.jboss.deployers.plugins.deployers.helpers.SecurityActions;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXPDeployer<T>
extends AbstractParsingDeployer<T> {
    private boolean useNamespaceAwareParser = true;
    private boolean validateDTDs;
    private DocumentBuilderFactory documentBuilderFactory;

    public JAXPDeployer(Class<T> deploymentType) {
        super(deploymentType);
    }

    public boolean isUseNamespaceAwareParser() {
        return this.useNamespaceAwareParser;
    }

    public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser) {
        this.useNamespaceAwareParser = useNamespaceAwareParser;
    }

    public boolean isValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validateDTDs) {
        this.validateDTDs = validateDTDs;
    }

    protected DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            throw new IllegalStateException("Document builder factory has not been constructed");
        }
        return this.documentBuilderFactory;
    }

    public void create() throws Exception {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(this.useNamespaceAwareParser);
        this.documentBuilderFactory.setValidating(this.validateDTDs);
    }

    public void destroy() {
        this.documentBuilderFactory = null;
    }

    @Override
    protected T parse(DeploymentUnit unit, VirtualFile file, T root) throws Exception {
        Document document = this.doParse(unit, file);
        return this.parse(unit, file, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document doParse(DeploymentUnit unit, VirtualFile file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        Document document = unit.getAttachment(Document.class);
        if (document == null) {
            InputStream is = SecurityActions.openStream(file);
            try {
                DocumentBuilder parser = this.getDocumentBuilderFactory().newDocumentBuilder();
                InputSource source = new InputSource(is);
                source.setSystemId(file.toURI().toString());
                parser.setEntityResolver(new JBossEntityResolver());
                document = parser.parse(is);
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignored) {}
            }
        }
        if (document != null) {
            unit.getTransientManagedObjects().addAttachment(Document.class, document);
        }
        return document;
    }

    @Override
    protected abstract T parse(DeploymentUnit var1, VirtualFile var2, Document var3) throws Exception;
}

