/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.kernel;

import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.plugins.deployers.helpers.AbstractComponentDeployer;
import org.jboss.deployers.plugins.deployers.helpers.SimpleDeploymentVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.kernel.spi.deployment.KernelDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelDeploymentDeployer
extends AbstractComponentDeployer<KernelDeployment, BeanMetaData> {
    public KernelDeploymentDeployer() {
        this.setDeploymentVisitor(new KernelDeploymentVisitor());
        this.setComponentVisitor(new BeanMetaDataVisitor());
    }

    protected static void addBeanComponent(DeploymentUnit unit, BeanMetaData bean) {
        DeploymentUnit component = unit.addComponent(bean.getName());
        component.addAttachment(BeanMetaData.class.getName(), bean);
    }

    protected static void removeBeanComponent(DeploymentUnit unit, BeanMetaData bean) {
        unit.removeComponent(bean.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanMetaDataVisitor
    implements SimpleDeploymentVisitor<BeanMetaData> {
        @Override
        public Class<BeanMetaData> getVisitorType() {
            return BeanMetaData.class;
        }

        @Override
        public void deploy(DeploymentUnit unit, BeanMetaData deployment) throws DeploymentException {
            KernelDeploymentDeployer.addBeanComponent(unit, deployment);
        }

        @Override
        public void undeploy(DeploymentUnit unit, BeanMetaData deployment) {
            KernelDeploymentDeployer.removeBeanComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KernelDeploymentVisitor
    implements SimpleDeploymentVisitor<KernelDeployment> {
        @Override
        public Class<KernelDeployment> getVisitorType() {
            return KernelDeployment.class;
        }

        @Override
        public void deploy(DeploymentUnit unit, KernelDeployment deployment) throws DeploymentException {
            List<BeanMetaData> beans = deployment.getBeans();
            for (BeanMetaData bean : beans) {
                KernelDeploymentDeployer.addBeanComponent(unit, bean);
            }
        }

        @Override
        public void undeploy(DeploymentUnit unit, KernelDeployment deployment) {
            List<BeanMetaData> beans = deployment.getBeans();
            for (BeanMetaData bean : beans) {
                KernelDeploymentDeployer.removeBeanComponent(unit, bean);
            }
        }
    }
}

