/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployers.plugins.deployers.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.J2eeApplicationMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARInitializingDeployer
extends AbstractSimpleRealDeployer<J2eeApplicationMetaData> {
    public EARInitializingDeployer() {
        super(J2eeApplicationMetaData.class);
    }

    @Override
    public void deploy(DeploymentUnit unit, J2eeApplicationMetaData deployment) throws DeploymentException {
        String contextID = EARInitializingDeployer.shortNameFromDeploymentName(unit.getSimpleName());
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
            unit.addAttachment(PolicyConfiguration.class, pc);
        }
        catch (PolicyContextException e) {
            throw new DeploymentException("PolicyContextException generated in deploy", e);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception generated in deploy", e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, J2eeApplicationMetaData deployment) {
        unit.removeAttachment(PolicyConfiguration.class);
    }

    public static String shortNameFromDeploymentName(String name) {
        String shortName = name.trim();
        String[] parts = name.split("/|\\.|\\!");
        if (parts.length > 1) {
            shortName = parts[parts.length - 1].equals("ear") ? parts[parts.length - 2] : parts[parts.length - 1];
        }
        return shortName;
    }
}

