/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployment.security.JaccPolicy;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccPolicyUtil {
    public static String getJaccPolicyServiceName(DeploymentUnit unit) {
        DeploymentUnit du = JaccPolicyUtil.getTopLevelDeployment(unit);
        return JaccPolicy.BASE_OBJECT_NAME + du.getSimpleName();
    }

    public static List<String> getJaccDeployments(DeploymentUnit unit, Collection<String> ignoreSuffix) {
        ArrayList<String> list2 = new ArrayList<String>();
        DeploymentContext dc = unit.getDeploymentContext();
        Set<DeploymentContext> dcset = dc.getChildren();
        for (DeploymentContext childDC : dcset) {
            String childName = childDC.getSimpleName();
            boolean tobeIgnored = false;
            for (String ignoreStr : ignoreSuffix) {
                tobeIgnored = false;
                if (!childName.endsWith(ignoreStr)) continue;
                tobeIgnored = true;
                break;
            }
            if (childName.endsWith("jar") && !tobeIgnored && !JaccPolicyUtil.isEJBDeployment(childDC.getDeploymentUnit()) || tobeIgnored) continue;
            list2.add(childName);
        }
        return list2;
    }

    public static void getServiceAttributeMetaData(DeploymentUnit unit, List<ServiceAttributeMetaData> attrs) {
        if (unit.getAttachment("jboss.jaccpolicy") != null) {
            ServiceAttributeMetaData jaccAttr = new ServiceAttributeMetaData();
            jaccAttr.setName("JaccPolicy");
            ServiceDependencyValueMetaData jaccDepends = new ServiceDependencyValueMetaData();
            jaccDepends.setDependency(JaccPolicyUtil.getJaccPolicyServiceName(unit));
            jaccDepends.setProxyType("attribute");
            jaccAttr.setValue(jaccDepends);
            attrs.add(jaccAttr);
        }
    }

    private static boolean isEJBDeployment(DeploymentUnit du) {
        boolean ejbxml = du.getMetaDataFile("ejb-jar.xml") != null;
        boolean jbossxml = du.getMetaDataFile("jboss.xml") != null;
        return ejbxml || jbossxml;
    }

    private static DeploymentUnit getTopLevelDeployment(DeploymentUnit unit) {
        DeploymentUnit tempDU = unit;
        DeploymentUnit toplevel = tempDU.getParent();
        if (toplevel != null) {
            tempDU = toplevel;
            toplevel = tempDU.getParent();
        }
        return tempDU;
    }
}

