/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.clientmodule;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.clientmodule.ClientEjbResolver;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.deployers.JBoss5DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DeploymentUnit;
import org.jboss.ejb3.enc.DeploymentEjbResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.metamodel.ApplicationClientDD;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiInjectHandler;
import org.jboss.injection.PersistenceContextHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.virtual.VirtualFile;
import org.jboss.ws.integration.ServiceRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientENCInjectionContainer
implements InjectionContainer {
    private static final Logger log = Logger.getLogger(ClientENCInjectionContainer.class);
    private DeploymentUnit ejb3Unit;
    private ApplicationClientDD xml;
    private Class<?> mainClass;
    private String applicationClientName;
    private ClassLoader classLoader;
    private List<Injector> injectors = new ArrayList<Injector>();
    private Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    private Map<String, EncInjector> encInjectors = new HashMap<String, EncInjector>();
    private Context enc;
    private DeploymentEjbResolver ejbResolver;
    private ObjectName objectName;
    private DependencyPolicy dependencyPolicy = new JBoss5DependencyPolicy();

    public ClientENCInjectionContainer(org.jboss.deployers.spi.deployer.DeploymentUnit unit, ApplicationClientDD xml, Class<?> mainClass, String applicationClientName, ClassLoader classLoader, Context encCtx) throws NamingException {
        if (mainClass == null) {
            throw new NullPointerException("mainClass is mandatory");
        }
        if (applicationClientName == null) {
            throw new NullPointerException("applicationClientName is mandatory");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is mandatory");
        }
        this.ejb3Unit = new JBoss5DeploymentUnit(unit);
        this.xml = xml;
        this.mainClass = mainClass;
        this.applicationClientName = applicationClientName;
        this.classLoader = classLoader;
        this.enc = encCtx;
        JBoss5DeploymentScope scope = null;
        if (unit.getDeploymentContext().getParent() != null) {
            scope = new JBoss5DeploymentScope(unit.getDeploymentContext().getParent());
        }
        this.ejbResolver = new ClientEjbResolver(scope, unit.getDeploymentContext().getRoot().getName());
        String on = "jboss.j2ee:service=EJB3" + this.createScopeKernelName(unit, scope) + ",name=" + applicationClientName;
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.processMetaData();
    }

    private String createScopeKernelName(org.jboss.deployers.spi.deployer.DeploymentUnit unit, DeploymentScope ear) {
        String scopedKernelName = "";
        if (ear != null) {
            scopedKernelName = scopedKernelName + ",ear=" + ear.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + unit.getDeploymentContext().getRoot().getName();
        return scopedKernelName;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        return clazz.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        return method.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return field.getAnnotation(annotationType);
    }

    @Override
    public VirtualFile getRootFile() {
        return this.ejb3Unit.getRootFile();
    }

    @Override
    public ClassLoader getClassloader() {
        return this.classLoader;
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    @Override
    public String getDeploymentDescriptorType() {
        return "application-client.xml";
    }

    @Override
    public String getEjbJndiName(Class businessInterface) throws NameNotFoundException {
        return this.ejbResolver.getEjbJndiName(businessInterface);
    }

    @Override
    public String getEjbJndiName(String link, Class businessInterface) {
        return this.ejbResolver.getEjbJndiName(link, businessInterface);
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    @Override
    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    @Override
    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    @Override
    public EnvironmentRefGroup getEnvironmentRefGroup() {
        return this.xml;
    }

    @Override
    public String getIdentifier() {
        return this.applicationClientName;
    }

    @Override
    public List<Injector> getInjectors() {
        return this.injectors;
    }

    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        throw new RuntimeException("NYI");
    }

    private void populateEnc() {
        for (EncInjector injector : this.encInjectors.values()) {
            log.trace("encInjector: " + injector);
            injector.inject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetaData() {
        for (String dependency : this.xml.getDependencies()) {
            this.getDependencyPolicy().addDependency(dependency);
        }
        ArrayList<InjectionHandler> handlers = new ArrayList<InjectionHandler>();
        handlers.add(new EJBHandler());
        handlers.add(new DependsHandler());
        handlers.add(new JndiInjectHandler());
        handlers.add(new PersistenceContextHandler());
        handlers.add(new PersistenceUnitHandler());
        handlers.add(new ResourceHandler());
        handlers.add(new WebServiceRefHandler());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            for (InjectionHandler handler : handlers) {
                handler.loadXml(this.xml, this);
            }
            Map<AccessibleObject, Injector> tmp = InjectionUtil.processAnnotations(this, handlers, this.getMainClass());
            this.injectors.addAll(tmp.values());
            if (this.xml != null) {
                for (ServiceRefMetaData sref : this.xml.getServiceRefs()) {
                    if (sref.isProcessed()) continue;
                    try {
                        String name = sref.getServiceRefName();
                        String encName = "env/" + name;
                        Context encCtx = this.getEnc();
                        VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(this.getRootFile());
                        new ServiceRefDelegate().bindServiceRef(encCtx, encName, vfsRoot, this.getClassloader(), sref);
                    }
                    catch (Exception e) {
                        log.error("Failed to bind service-ref", e);
                    }
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public Container resolveEjbContainer(String link, Class businessIntf) {
        return this.ejbResolver.getEjbContainer(link, businessIntf);
    }

    @Override
    public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.ejbResolver.getEjbContainer(businessIntf);
    }

    public void start() {
        log.trace("start");
        this.populateEnc();
    }

    public void stop() {
        log.trace("stop");
    }
}

