/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.resource;

import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.MessageListenerMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class Ejb3DeploymentInfo
extends DeploymentInfo {
    private static final Logger log = Logger.getLogger(Ejb3DeploymentInfo.class);
    protected String rarName;
    protected String listenerType;
    protected String activationSpecType;

    public Ejb3DeploymentInfo(String rarName, String listenerType, String activationSpecType) throws Exception {
        super(Thread.currentThread().getContextClassLoader().getResource(rarName), null, null);
        this.rarName = rarName;
        this.listenerType = listenerType;
        this.activationSpecType = activationSpecType;
        MessageListenerMetaData listener = new MessageListenerMetaData();
        listener.setType(listenerType);
        listener.setActivationSpecType(activationSpecType);
        ConnectorMetaData metaData = this.getConnectorMetaData();
        this.metaData = metaData;
    }

    protected ConnectorMetaData getConnectorMetaData() throws Exception {
        ResourceAdapterObjectModelFactory factory = new ResourceAdapterObjectModelFactory();
        UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
        Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
        URL rar = Thread.currentThread().getContextClassLoader().getResource(this.rarName);
        JarFile rarFile = new JarFile(rar.getFile());
        ZipEntry entry = rarFile.getEntry("META-INF/ra.xml");
        ConnectorMetaData metaData = (ConnectorMetaData)unmarshaller.unmarshal(rarFile.getInputStream(entry), (ObjectModelFactory)factory, null);
        return metaData;
    }
}

