/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.ejb3.stateful.ForwardId;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.id.GUID;

public class StatefulRemoteProxy
extends BaseSessionRemoteProxy {
    private static final long serialVersionUID = -2164496320326661428L;
    private static final Logger log = Logger.getLogger(StatefulRemoteProxy.class);
    protected InvokerLocator uri;
    AsynchProvider provider;
    private Handle handle;
    private HomeHandle homeHandle;
    private EJBMetaData ejbMetaData;

    public StatefulRemoteProxy(Object containerId, Interceptor[] interceptors, InvokerLocator uri) {
        super(containerId, interceptors);
        this.uri = uri;
    }

    public StatefulRemoteProxy(Object containerId, Interceptor[] interceptors, InvokerLocator uri, Object id) {
        super(containerId, interceptors);
        this.uri = uri;
        this.id = id;
    }

    public StatefulRemoteProxy(AsynchProvider provider, Object containerId, Interceptor[] interceptors, InvokerLocator uri) {
        super(containerId, interceptors);
        this.uri = uri;
        this.provider = provider;
    }

    protected StatefulRemoteProxy() {
    }

    public void setHandle(StatefulHandleImpl handle) {
        this.handle = handle;
        handle.id = this.id;
    }

    public void setHomeHandle(HomeHandle homeHandle) {
        this.homeHandle = homeHandle;
    }

    public void setEjbMetaData(EJBMetaData ejbMetaData) {
        this.ejbMetaData = ejbMetaData;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        long hash = MethodHashing.calculateHash(method);
        Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        ret = this.handleEjb21CallLocally(method, args);
        if (ret != null) {
            return ret;
        }
        StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, this.id);
        sri.setArguments(args);
        sri.setInstanceResolver(this.metadata);
        sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
        if (this.provider != null) {
            sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
        }
        try {
            Object rtn = sri.invokeNext();
            if (this.id == null) {
                this.id = sri.getResponseAttachment("NEW_ID");
            }
            return rtn;
        }
        catch (ForwardId forward) {
            this.id = forward.getId();
            throw forward.getCause();
        }
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
            StatefulRemoteProxy handler = new StatefulRemoteProxy(mixin, this.containerId, newInterceptors, this.uri);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.id != null) {
            return this.containerId.toString() + ":" + this.id.toString();
        }
        GUID guid = new GUID();
        return this.containerId.toString() + ":" + guid.toString();
    }

    private Object handleEjb21CallLocally(Method method, Object[] args) {
        if (method.equals(ProxyUtils.GET_HOME_HANDLE)) {
            return this.homeHandle;
        }
        if (method.equals(ProxyUtils.GET_EJB_METADATA)) {
            return this.ejbMetaData;
        }
        if (method.equals(ProxyUtils.GET_HANDLE)) {
            return this.handle;
        }
        return null;
    }
}

