/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class BinaryBootstrap
extends Bootstrap {
    private static Bootstrap instance;

    public BinaryBootstrap(Kernel kernel) {
        super(kernel);
    }

    public static synchronized Bootstrap getInstance() {
        if (instance == null) {
            instance = new BinaryBootstrap(BinaryBootstrap.createKernel());
        }
        return instance;
    }

    public static KernelDeployment parse(URL url) throws JBossXBException, MalformedURLException {
        SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(KernelDeployment deployment, File binFile) throws Exception {
        FileOutputStream fos = new FileOutputStream(binFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        try {
            oos.writeObject(deployment);
        }
        finally {
            oos.close();
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KernelDeployment load(File binFile) throws Exception {
        FileInputStream fis = new FileInputStream(binFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            KernelDeployment deployment;
            KernelDeployment kernelDeployment = deployment = (KernelDeployment)ois.readObject();
            return kernelDeployment;
        }
        finally {
            ois.close();
            fis.close();
        }
    }

    protected void deployBaseBootstrapUrl(URL url) throws DeploymentException {
        try {
            KernelDeployment deployment;
            URI uri = url.toURI();
            URI binUri = new URI(uri.toString() + ".bin");
            File textFile = new File(uri);
            File binFile = new File(binUri);
            if (!binFile.exists() && !textFile.exists()) {
                throw new DeploymentException("Unable to locate bootstrap file: " + url);
            }
            if (binFile.exists() && textFile.exists()) {
                if (textFile.lastModified() > binFile.lastModified()) {
                    System.out.println("new bootstrap file...");
                    deployment = BinaryBootstrap.parse(url);
                    BinaryBootstrap.store(deployment, binFile);
                } else {
                    deployment = BinaryBootstrap.load(binFile);
                }
            } else if (textFile.exists()) {
                deployment = BinaryBootstrap.parse(url);
                BinaryBootstrap.store(deployment, binFile);
            } else {
                deployment = BinaryBootstrap.load(binFile);
            }
            AbstractKernelDeployer deployer = new AbstractKernelDeployer(this.kernel);
            deployer.deploy(deployment);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to bootstrap: ", throwable);
        }
    }
}

