/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.logging.Logger;

public class ConnectionFactoryCallbackHandler {
    private static final Logger log = Logger.getLogger(ConnectionFactoryCallbackHandler.class);
    private ClientConnectionDelegate connectionDelegate;
    private ConnectionState state;
    private static boolean trace = log.isTraceEnabled();

    public ConnectionFactoryCallbackHandler(ClientConnectionDelegate connectionDelegate) {
        this.connectionDelegate = connectionDelegate;
    }

    public void handleMessage(Object message) {
        if (trace) {
            log.trace(this + " handling " + message);
        }
        ConnectionFactoryUpdate viewChange = (ConnectionFactoryUpdate)message;
        ConnectionFactoryDelegate d = this.getState().getClusteredConnectionFactoryDelegate();
        if (d instanceof ClientClusteredConnectionFactoryDelegate) {
            ClientClusteredConnectionFactoryDelegate clusteredDelegate = (ClientClusteredConnectionFactoryDelegate)d;
            clusteredDelegate.updateFailoverInfo(viewChange.getDelegates(), viewChange.getFailoverMap());
        }
    }

    public String toString() {
        return "ConnectionFactoryCallbackHandler[" + this.connectionDelegate + "]";
    }

    protected ConnectionState getState() {
        if (this.state == null) {
            this.state = (ConnectionState)this.connectionDelegate.getState();
        }
        return this.state;
    }
}

