/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Version;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackPoller;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.stream.StreamServer;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.local.LocalClientInvoker;
import org.jboss.util.id.GUID;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;

public class Client
implements Externalizable {
    public static final String ONEWAY_FLAG = "oneway";
    public static final String LISTENER_ID_KEY = "listenerId";
    public static final int MAX_NUM_ONEWAY_THREADS_DEFAULT = 10;
    public static final String RAW = "rawPayload";
    public static final String ENABLE_LEASE = "enableLease";
    public static final String HANDSHAKE_COMPLETED_LISTENER = "handshakeCompletedListener";
    public static final String CALLBACK_SERVER_PROTOCOL = "callbackServerProtocol";
    public static final String CALLBACK_SERVER_HOST = "callbackServerHost";
    public static final String CALLBACK_SERVER_PORT = "callbackServerPort";
    public static final String MAX_NUM_ONEWAY_THREADS = "maxNumThreadsOneway";
    public static final String MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE = "maxOnewayThreadPoolQueueSize";
    public static final int DEFAULT_DISCONNECT_TIMEOUT = -1;
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$Client == null ? (class$org$jboss$remoting$Client = Client.class$("org.jboss.remoting.Client")) : class$org$jboss$remoting$Client);
    private static final long serialVersionUID = 5679279425009837934L;
    private int maxNumberThreads = 10;
    private int maxOnewayThreadPoolQueueSize = -1;
    private ClientInvoker invoker;
    private ClassLoader classloader;
    private String subsystem;
    private String sessionId;
    private Object onewayThreadPoolLock = new Object();
    private ThreadPool onewayThreadPool;
    private InvokerLocator locator;
    private ConnectionValidator connectionValidator = null;
    private Map configuration = new HashMap();
    private Map callbackConnectors = new HashMap();
    private Map callbackPollers = new HashMap();
    private Map listeners = new HashMap();
    private SocketFactory socketFactory;
    private int disconnectTimeout = -1;
    private boolean connected = false;
    static /* synthetic */ Class class$org$jboss$remoting$Client;

    public Client() {
    }

    public Client(InvokerLocator locator) throws Exception {
        this(locator, null, null);
    }

    public Client(InvokerLocator locator, Map configuration) throws Exception {
        this(locator, null, configuration);
    }

    public Client(InvokerLocator locator, String subsystem) throws Exception {
        this(locator, subsystem, null);
    }

    public Client(InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this(Thread.currentThread().getContextClassLoader(), locator, subsystem, configuration);
    }

    public Client(ClassLoader cl, InvokerLocator locator, String subsystem, Map configuration) throws Exception {
        this.classloader = cl;
        this.locator = locator;
        String string = this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        if (configuration != null) {
            this.configuration = new HashMap(configuration);
        }
        this.sessionId = new GUID().toString();
    }

    public Client(ClassLoader cl, ClientInvoker invoker, String subsystem) throws Exception {
        this.classloader = cl;
        this.subsystem = subsystem == null ? null : subsystem.toUpperCase();
        this.invoker = invoker;
        this.sessionId = new GUID().toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 2: 
            case 22: {
                this.locator = (InvokerLocator)in.readObject();
                this.subsystem = (String)in.readObject();
                this.configuration = (Map)in.readObject();
                boolean wasConnected = in.readBoolean();
                this.classloader = Thread.currentThread().getContextClassLoader();
                try {
                    this.invoker = InvokerRegistry.createClientInvoker(this.locator, this.configuration);
                    if (!wasConnected) break;
                    this.connect();
                    break;
                }
                catch (Exception e) {
                    log.error(e);
                    throw new IOException(e.getMessage());
                }
            }
            default: {
                throw new StreamCorruptedException("Unkown version seen: " + version);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(Version.getDefaultVersion());
        out.writeObject(this.invoker != null ? this.invoker.getLocator() : this.locator);
        out.writeObject(this.subsystem);
        out.writeObject(this.configuration);
        out.writeBoolean(this.isConnected());
        out.flush();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.addConnectionListener(listener, 2000);
    }

    public void addConnectionListener(ConnectionListener listener, int pingPeriod) {
        if (this.invoker == null) {
            throw new RuntimeException("Can not add connection listener to remoting client until client has been connected.");
        }
        if (this.invoker instanceof LocalClientInvoker) {
            return;
        }
        if (this.connectionValidator == null) {
            this.connectionValidator = new ConnectionValidator(this, pingPeriod);
        }
        this.connectionValidator.addConnectionListener(listener);
    }

    public boolean removeConnectionListener(ConnectionListener listener) {
        if (this.connectionValidator == null) {
            return false;
        }
        return this.connectionValidator.removeConnectionListener(listener);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void connect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        if (this.locator == null) {
            throw new IllegalStateException("Cannot connect a client with a null locator");
        }
        if (this.invoker == null) {
            if (this.socketFactory != null) {
                this.configuration.put("customSocketFactory", this.socketFactory);
                this.socketFactory = null;
            }
            this.invoker = InvokerRegistry.createClientInvoker(this.locator, this.configuration);
        }
        this.connect(this.invoker);
        this.connected = true;
    }

    public void disconnect() {
        if (this.invoker != null) {
            this.invoker.terminateLease(this.sessionId, this.disconnectTimeout);
            if (this.connectionValidator != null) {
                this.connectionValidator.stop();
                this.connectionValidator = null;
            }
            InvokerRegistry.destroyClientInvoker(this.invoker.getLocator(), this.configuration);
            this.invoker = null;
        }
        this.connected = false;
    }

    public ClientInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ClientInvoker invoker) {
        this.invoker = invoker;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public Object invoke(Object param) throws Throwable {
        return this.invoke(param, null);
    }

    public Object invoke(Object param, Map metadata) throws Throwable {
        return this.invoke(param, metadata, null);
    }

    public void invokeOneway(final Object param, Map sendPayload, boolean clientSide) throws Throwable {
        final Map internalSendPayload = sendPayload == null ? new HashMap() : sendPayload;
        internalSendPayload.put(ONEWAY_FLAG, "true");
        if (clientSide) {
            ThreadPool threadPool = this.getOnewayThreadPool();
            Runnable onewayRun = new Runnable(){

                public void run() {
                    try {
                        Client.this.invoke(param, internalSendPayload);
                    }
                    catch (Throwable e) {
                        log.error("Error executing client oneway invocation request: " + param, e);
                    }
                }
            };
            threadPool.run(onewayRun);
        } else {
            OnewayInvocation invocation = new OnewayInvocation(param);
            this.invoke(invocation, internalSendPayload);
        }
    }

    public Set getCallbackConnectors(InvokerCallbackHandler callbackHandler) {
        return (Set)this.callbackConnectors.get(callbackHandler);
    }

    public int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(int disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public void setMaxOnewayThreadPoolQueueSize(int maxOnewayThreadPoolQueueSize) {
        this.maxOnewayThreadPoolQueueSize = maxOnewayThreadPoolQueueSize;
    }

    public int getMaxOnewayThreadPoolQueueSize() {
        return this.maxOnewayThreadPoolQueueSize;
    }

    public void setMaxNumberOfThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfThreads() {
        return this.maxNumberThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getOnewayThreadPool() {
        Object object = this.onewayThreadPoolLock;
        synchronized (object) {
            if (this.onewayThreadPool == null) {
                BasicThreadPool pool = new BasicThreadPool("JBossRemoting Client Oneway");
                log.debug("created new thread pool: " + pool);
                Object param = this.configuration.get(MAX_NUM_ONEWAY_THREADS);
                if (param instanceof String) {
                    try {
                        this.maxNumberThreads = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error("maxNumberThreads parameter has invalid format: " + param);
                    }
                } else if (param != null) {
                    log.error("maxNumberThreads parameter must be a string in integer format: " + param);
                }
                if ((param = this.configuration.get(MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE)) instanceof String) {
                    try {
                        this.maxOnewayThreadPoolQueueSize = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        log.error("maxOnewayThreadPoolQueueSize parameter has invalid format: " + param);
                    }
                } else if (param != null) {
                    log.error("maxOnewayThreadPoolQueueSize parameter must be a string in integer format: " + param);
                }
                pool.setMaximumPoolSize(this.maxNumberThreads);
                if (this.maxOnewayThreadPoolQueueSize > 0) {
                    pool.setMaximumQueueSize(this.maxOnewayThreadPoolQueueSize);
                }
                pool.setBlockingMode(BlockingMode.RUN);
                this.onewayThreadPool = pool;
            }
        }
        return this.onewayThreadPool;
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        if (this.isConnected()) {
            throw new RuntimeException("Cannot set socket factory on Client after the connect() method has been called.");
        }
        if (this.invoker != null) {
            this.invoker.setSocketFactory(socketFactory);
        } else {
            this.socketFactory = socketFactory;
        }
    }

    public SocketFactory getSocketFactory() {
        if (this.invoker != null) {
            return this.invoker.getSocketFactory();
        }
        return this.socketFactory;
    }

    public void invokeOneway(Object param) throws Throwable {
        this.invokeOneway(param, null);
    }

    public void invokeOneway(Object param, Map sendPayload) throws Throwable {
        this.invokeOneway(param, sendPayload, false);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata) throws Throwable {
        this.addListener(callbackhandler, metadata, null);
    }

    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject) throws Throwable {
        this.addListener(callbackhandler, metadata, callbackHandlerObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addListener(InvokerCallbackHandler callbackhandler, Map metadata, Object callbackHandlerObject, boolean serverToClient) throws Throwable {
        InvokerLocator callbackLocator = null;
        if (!this.isConnected()) throw new Exception("Can not add callback listener because remoting client is not connected to server.");
        if (callbackhandler == null) throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        boolean isBidirectional = this.invoker instanceof BidirectionalClientInvoker;
        if (isBidirectional || serverToClient) {
            String transport = null;
            String host = null;
            int port = -1;
            if (metadata != null) {
                transport = (String)metadata.get(CALLBACK_SERVER_PROTOCOL);
                host = (String)metadata.get(CALLBACK_SERVER_HOST);
                String sPort = (String)metadata.get(CALLBACK_SERVER_PORT);
                if (sPort != null) {
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Could not set the internal callback server port as configuration value (" + sPort + ") is not a number.");
                    }
                }
            } else {
                metadata = new HashMap();
            }
            if (transport == null) {
                transport = this.invoker.getLocator().getProtocol();
                metadata.put(CALLBACK_SERVER_PROTOCOL, transport);
            }
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
                metadata.put(CALLBACK_SERVER_HOST, host);
            }
            if (port == -1) {
                port = PortUtil.findFreePort(host);
                metadata.put(CALLBACK_SERVER_PORT, String.valueOf(port));
            }
            callbackLocator = isBidirectional ? ((BidirectionalClientInvoker)this.invoker).getCallbackLocator(metadata) : new InvokerLocator(transport, host, port, null, metadata);
            log.debug("starting callback Connector: " + callbackLocator);
            Connector callbackServerConnector = new Connector(callbackLocator, this.configuration);
            Map map = this.callbackConnectors;
            synchronized (map) {
                HashSet<Connector> connectors = (HashSet<Connector>)this.callbackConnectors.get(callbackhandler);
                if (connectors == null) {
                    connectors = new HashSet<Connector>();
                }
                connectors.add(callbackServerConnector);
                this.callbackConnectors.put(callbackhandler, connectors);
            }
            callbackServerConnector.start();
            callbackLocator = callbackServerConnector.getServerInvoker().getLocator();
        } else {
            CallbackPoller poller = new CallbackPoller(this, callbackhandler, metadata, callbackHandlerObject);
            this.callbackPollers.put(callbackhandler, poller);
            poller.start();
        }
        this.addCallbackListener(callbackhandler, metadata, callbackLocator, callbackHandlerObject);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        this.addListener(callbackHandler, (InvokerLocator)null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator) throws Throwable {
        this.addListener(callbackHandler, clientLocator, null);
    }

    public void addListener(InvokerCallbackHandler callbackHandler, InvokerLocator clientLocator, Object callbackHandlerObject) throws Throwable {
        if (callbackHandler != null) {
            if (!this.isConnected()) {
                throw new Exception("Can not add callback listener as remoting client is not connected to server.");
            }
        } else {
            throw new NullPointerException("InvokerCallbackHandler to be added as a listener can not be null.");
        }
        this.addCallbackListener(callbackHandler, null, clientLocator, callbackHandlerObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeListener(InvokerCallbackHandler callbackHandler) throws Throwable {
        if (!this.isConnected()) throw new Exception("Can not remove callback listener as remoting client is not connected to server.");
        if (callbackHandler == null) throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
        String listenerId = (String)this.listeners.get(callbackHandler);
        if (listenerId != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(LISTENER_ID_KEY, listenerId);
            this.invoke(new InternalInvocation("removeListener", null), metadata);
            CallbackPoller callbackPoller = (CallbackPoller)this.callbackPollers.remove(callbackHandler);
            if (callbackPoller != null) {
                callbackPoller.stop();
            }
            this.listeners.remove(callbackHandler);
        } else {
            List holderList = this.invoker.getClientLocators(this.sessionId, callbackHandler);
            if (holderList != null && holderList.size() > 0) {
                for (int x = 0; x < holderList.size(); ++x) {
                    AbstractInvoker.CallbackLocatorHolder holder = (AbstractInvoker.CallbackLocatorHolder)holderList.get(x);
                    listenerId = holder.getListenerId();
                    InvokerLocator locator = holder.getLocator();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    metadata.put(LISTENER_ID_KEY, listenerId);
                    if (this.disconnectTimeout != 0) {
                        if (this.disconnectTimeout > 0) {
                            metadata.put("timeout", Integer.toString(this.disconnectTimeout));
                        }
                        try {
                            InternalInvocation ii = new InternalInvocation("removeListener", null);
                            this.invoke(ii, metadata);
                        }
                        catch (Exception e) {
                            log.warn("unable to remove remote callback handler: " + e.getMessage());
                        }
                    }
                    Client client = new Client(locator, this.subsystem);
                    client.setSessionId(this.getSessionId());
                    client.connect();
                    InternalInvocation ii = new InternalInvocation("removeClientListener", new Object[]{callbackHandler});
                    client.invoke(ii, metadata);
                    client.disconnect();
                }
            }
        }
        Set connectors = null;
        Map x = this.callbackConnectors;
        synchronized (x) {
            connectors = (Set)this.callbackConnectors.remove(callbackHandler);
        }
        if (connectors == null) return;
        Iterator it = connectors.iterator();
        while (it.hasNext()) {
            Connector callbackConnector = (Connector)it.next();
            callbackConnector.stop();
            callbackConnector.destroy();
        }
    }

    public List getCallbacks(InvokerCallbackHandler callbackHandler) throws Throwable {
        if (callbackHandler != null) {
            String listenerId = (String)this.listeners.get(callbackHandler);
            if (listenerId != null) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put(LISTENER_ID_KEY, listenerId);
                return (List)this.invoke(new InternalInvocation("getCallbacks", null), metadata);
            }
            log.error("Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler has been registered as listener.");
            return null;
        }
        throw new NullPointerException("Can not remove null InvokerCallbackHandler listener.");
    }

    public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback) throws Throwable {
        return this.acknowledgeCallback(callbackHandler, callback, null);
    }

    public int acknowledgeCallback(InvokerCallbackHandler callbackHandler, Callback callback, Object response) throws Throwable {
        ArrayList<Callback> callbacks = new ArrayList<Callback>(1);
        callbacks.add(callback);
        ArrayList<Object> responses = null;
        if (response != null) {
            responses = new ArrayList<Object>(1);
            responses.add(response);
        }
        return this.acknowledgeCallbacks(callbackHandler, callbacks, responses);
    }

    public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks) throws Throwable {
        return this.acknowledgeCallbacks(callbackHandler, callbacks, null);
    }

    public int acknowledgeCallbacks(InvokerCallbackHandler callbackHandler, List callbacks, List responses) throws Throwable {
        if (callbackHandler == null) {
            throw new Exception("InvokerCallbackHandler parameter must not be null");
        }
        if (callbacks == null) {
            throw new Exception("Callback List parameter must not be null");
        }
        if (responses != null && responses.size() != callbacks.size()) {
            throw new Exception("Callback response list must be (1) null or (2) the same size as callback list");
        }
        if (callbacks.size() == 0) {
            return 0;
        }
        if (this.isConnected()) {
            ArrayList callbackIds = new ArrayList(callbacks.size());
            Iterator idsIterator = callbacks.iterator();
            ArrayList<Object> responseList = null;
            Iterator responseIterator = null;
            if (responses != null) {
                responseList = new ArrayList<Object>(responses.size());
                responseIterator = responses.iterator();
            }
            Callback callback = null;
            Object response = null;
            String listenerId = null;
            for (int i = 0; i < callbacks.size(); ++i) {
                Map returnPayload;
                callback = (Callback)idsIterator.next();
                if (responseIterator != null) {
                    response = responseIterator.next();
                }
                if ((returnPayload = callback.getReturnPayload()) != null) {
                    Object callbackId = returnPayload.get("callbackId");
                    if (callbackId != null) {
                        String nextListenerId;
                        callbackIds.add(callbackId);
                        if (responseIterator != null) {
                            responseList.add(response);
                        }
                        if ((nextListenerId = (String)returnPayload.get(LISTENER_ID_KEY)) == null) {
                            throw new Exception("Cannot acknowledge callbacks: callback " + callbackId + " has null listener id");
                        }
                        if (i == 0) {
                            listenerId = nextListenerId;
                            continue;
                        }
                        if (listenerId.equals(nextListenerId)) continue;
                        throw new Exception("Cannot acknowledge callbacks: all must be from same server side callback handler");
                    }
                    log.error("Cannot acknowledge callback: callback id is missing from return payload");
                    continue;
                }
                log.error("Cannot acknowledge callback: return payload is null");
            }
            if (callbackIds.size() == 0) {
                return 0;
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (listenerId == null) {
                throw new Exception("Could not find listener id for InvokerCallbackHandler (" + callbackHandler + "), please verify handler " + "has been registered as listener.");
            }
            metadata.put(LISTENER_ID_KEY, listenerId);
            Object[] params = new Object[]{callbackIds, responseList};
            InternalInvocation invocation = new InternalInvocation("acknowledgeCallback", params);
            this.invoke(invocation, metadata);
            return callbackIds.size();
        }
        throw new Exception("Can not acknowledge Callback due to not being connected to server.");
    }

    public void setMarshaller(Marshaller marshaller) {
        if (this.isConnected()) {
            if (marshaller == null) {
                throw new NullPointerException("Can not set Marshaller with a null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client Marshaller when not connected.");
        }
        this.invoker.setMarshaller(marshaller);
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        if (this.isConnected()) {
            if (unmarshaller == null) {
                throw new NullPointerException("Can not set UnMarshaller to null value.");
            }
        } else {
            throw new RuntimeException("Can not set remoting client UnMarhshaller when not connected.");
        }
        this.invoker.setUnMarshaller(unmarshaller);
    }

    public Object invoke(InputStream inputStream, Object param) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public Object invoke(InputStream inputStream, Object param, Connector streamConnector) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream, streamConnector);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public Object invoke(InputStream inputStream, Object param, InvokerLocator streamServerLocator) throws Throwable {
        StreamServer streamServer = new StreamServer(inputStream, streamServerLocator);
        String locator = streamServer.getInvokerLocator();
        InvocationRequest invocationRequest = new InvocationRequest(this.sessionId, this.subsystem, param, null, null, null);
        return this.invoke(new InternalInvocation("addStreamCallback", new Object[]{locator, invocationRequest}), null);
    }

    public long getPingPeriod() {
        if (this.connectionValidator == null) {
            return -1L;
        }
        return this.connectionValidator.getPingPeriod();
    }

    public long getLeasePeriod() {
        if (this.invoker == null) {
            return -1L;
        }
        return this.invoker.getLeasePeriod(this.sessionId);
    }

    public String toString() {
        return "Client[" + System.identityHashCode(this) + "]";
    }

    private void connect(ClientInvoker invoker) {
        if (invoker != null) {
            invoker.connect();
            try {
                this.setupClientLease(invoker);
            }
            catch (Throwable throwable) {
                RuntimeException e = new RuntimeException("Error setting up client lease upon performing connect.");
                e.initCause(throwable);
                throw e;
            }
        } else {
            throw new RuntimeException("Client invoker is null (may have used void constructor for Client, which should only be used for Externalization.");
        }
    }

    private void setupClientLease(ClientInvoker invoker) throws Throwable {
        long leasePeriod = -1L;
        boolean enableLease = false;
        if (invoker != null) {
            if (invoker instanceof LocalClientInvoker) {
                return;
            }
            InvokerLocator locator = invoker.getLocator();
            Map locatorParams = locator.getParameters();
            if (locatorParams != null) {
                String leasePeriodValue;
                String leaseValue = (String)locatorParams.get("leasing");
                if (leaseValue != null && leaseValue.length() > 0) {
                    enableLease = Boolean.valueOf(leaseValue);
                }
                if ((leasePeriodValue = (String)locatorParams.get("lease_period")) != null && leasePeriodValue.length() > 0) {
                    try {
                        leasePeriod = Long.parseLong(leasePeriodValue);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Could not convert client lease period value (" + leasePeriodValue + ") to a number.");
                    }
                }
            }
        } else {
            throw new RuntimeException("Can not set up client lease as client invoker is null.");
        }
        if (this.configuration != null) {
            String leasePeriodValue;
            Object val = this.configuration.get(ENABLE_LEASE);
            if (val != null) {
                if (val instanceof Boolean) {
                    enableLease = (Boolean)val;
                } else if (val instanceof String) {
                    enableLease = Boolean.valueOf((String)val);
                } else {
                    log.warn("Can not evaluate enableLease value (" + val + ") as a boolean type.");
                }
            }
            if ((leasePeriodValue = (String)this.configuration.get("lease_period")) != null && leasePeriodValue.length() > 0) {
                try {
                    leasePeriod = Long.parseLong(leasePeriodValue);
                }
                catch (NumberFormatException e) {
                    log.warn("Could not convert client lease period value (" + leasePeriodValue + ") to a number.");
                }
            }
        }
        if (enableLease) {
            invoker.establishLease(this.sessionId, this.configuration, leasePeriod);
        }
    }

    private Object invoke(Object param, Map metadata, InvokerLocator callbackServerLocator) throws Throwable {
        if (this.isConnected()) {
            return this.invoker.invoke(new InvocationRequest(this.sessionId, this.subsystem, param, metadata, null, callbackServerLocator));
        }
        throw new Exception("Can not make remoting client invocation due to not being connected to server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallbackListener(InvokerCallbackHandler callbackhandler, Map metadata, InvokerLocator callbackLocator, Object callbackHandlerObject) throws Throwable {
        if (callbackLocator == null) {
            String listenerId = this.generateListenerId(callbackhandler);
            if (listenerId != null) {
                HashMap<String, String> internalMetadata = new HashMap<String, String>();
                internalMetadata.put(LISTENER_ID_KEY, listenerId);
                if (metadata != null) {
                    internalMetadata.putAll(metadata);
                }
                this.invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
            }
        } else {
            String listenerId = this.invoker.addClientLocator(this.sessionId, callbackhandler, callbackLocator);
            if (listenerId != null) {
                HashMap<String, String> internalMetadata = new HashMap<String, String>();
                internalMetadata.put(LISTENER_ID_KEY, listenerId);
                if (metadata != null) {
                    internalMetadata.putAll(metadata);
                }
                Client client = new Client(callbackLocator, this.subsystem);
                client.setSessionId(this.getSessionId());
                client.connect();
                try {
                    InternalInvocation i = new InternalInvocation("addClientListener", new Object[]{callbackhandler, callbackHandlerObject});
                    client.invoke(i, internalMetadata);
                }
                finally {
                    client.disconnect();
                }
                this.invoke(new InternalInvocation("addListener", null), internalMetadata, callbackLocator);
            }
        }
    }

    private String generateListenerId(InvokerCallbackHandler callbackhandler) {
        String listenerId = null;
        Object obj = this.listeners.get(callbackhandler);
        if (obj == null) {
            listenerId = new GUID().toString();
            this.listeners.put(callbackhandler, listenerId);
        }
        return listenerId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

