/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.module.ClientAuthModule;
import org.jboss.security.SimplePrincipal;

public class SimpleClientAuthModule
implements ClientAuthModule {
    private Class[] supportedTypes = null;
    private SimplePrincipal principal = null;
    private Object credential = null;
    private MessagePolicy requestPolicy = null;
    private MessagePolicy responsePolicy = null;
    private CallbackHandler handler = null;
    private Map options = null;

    public SimpleClientAuthModule(Class[] supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.requestPolicy = requestPolicy;
        this.responsePolicy = responsePolicy;
        this.handler = handler;
        this.options = options;
    }

    public AuthStatus secureRequest(AuthParam param, Subject source, Map sharedState) throws AuthException {
        source.getPrincipals().add(this.principal);
        source.getPublicCredentials().add(this.credential);
        return AuthStatus.PROCEED;
    }

    public AuthStatus validateResponse(AuthParam param, Subject source, Subject recipient, Map sharedState) throws AuthException {
        Set<SimplePrincipal> sourceSet = source.getPrincipals(SimplePrincipal.class);
        Set<SimplePrincipal> recipientSet = recipient.getPrincipals(SimplePrincipal.class);
        if (sourceSet == null && recipientSet == null) {
            throw new AuthException("Principals are null");
        }
        if (sourceSet.size() != recipientSet.size()) {
            throw new AuthException("Principals size are different");
        }
        return AuthStatus.PROCEED;
    }

    public Class[] getSupportedMessageTypes() {
        return this.supportedTypes;
    }

    public AuthStatus cleanSubject(Subject subject, Map sharedState) throws AuthException {
        subject.getPrincipals().remove(this.principal);
        subject.getPublicCredentials().remove(this.credential);
        return AuthStatus.PROCEED;
    }
}

