/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.tm.TransactionDemarcationSupport;

public class Util {
    static Group[] getRoleSets(String targetUser, Properties roles, char roleGroupSeperator, AbstractServerLoginModule aslm) {
        Logger log = aslm.log;
        boolean trace = log.isTraceEnabled();
        Enumeration<?> users = roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements() && targetUser != null) {
            String user = (String)users.nextElement();
            String value = roles.getProperty(user);
            if (trace) {
                log.trace("Checking user: " + user + ", roles string: " + value);
            }
            int index = user.indexOf(roleGroupSeperator, targetUser.length());
            boolean isRoleGroup = false;
            boolean userMatch = false;
            if (index > 0 && targetUser.regionMatches(0, user, 0, index)) {
                isRoleGroup = true;
            } else {
                userMatch = targetUser.equals(user);
            }
            if (isRoleGroup) {
                String groupName = user.substring(index + 1);
                if (groupName.equals("Roles")) {
                    if (trace) {
                        log.trace("Adding to Roles: " + value);
                    }
                    Util.parseGroupMembers(rolesGroup, value, aslm);
                    continue;
                }
                if (trace) {
                    log.trace("Adding to " + groupName + ": " + value);
                }
                SimpleGroup group = new SimpleGroup(groupName);
                Util.parseGroupMembers(group, value, aslm);
                groups.add(group);
                continue;
            }
            if (!userMatch) continue;
            if (trace) {
                log.trace("Adding to Roles: " + value);
            }
            Util.parseGroupMembers(rolesGroup, value, aslm);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm) throws LoginException {
        return Util.getRoleSets(username, dsJndiName, rolesQuery, aslm, false);
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume) throws LoginException {
        LoginException le;
        Logger log = aslm.log;
        boolean trace = log.isTraceEnabled();
        Connection conn = null;
        HashMap<String, Group> setsMap = new HashMap<String, Group>();
        Statement ps = null;
        ResultSet rs = null;
        Transaction tx = null;
        if (suspendResume) {
            tx = TransactionDemarcationSupport.suspendAnyTransaction();
            if (trace) {
                log.trace("suspendAnyTransaction");
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            if (trace) {
                log.trace("Excuting query: " + rolesQuery + ", with username: " + username);
            }
            ps = conn.prepareStatement(rolesQuery);
            try {
                ps.setString(1, username);
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                // empty catch block
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                Group[] roleSets;
                if (trace) {
                    log.trace("No roles found");
                }
                if (aslm.getUnauthenticatedIdentity() == null) {
                    throw new FailedLoginException("No matching username found in Roles");
                }
                Group[] groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                return groupArray;
            }
            do {
                Group group;
                String name = rs.getString(1);
                String groupName = rs.getString(2);
                if (groupName == null || groupName.length() == 0) {
                    groupName = "Roles";
                }
                if ((group = (Group)setsMap.get(groupName)) == null) {
                    group = new SimpleGroup(groupName);
                    setsMap.put(groupName, group);
                }
                try {
                    Principal p = aslm.createIdentity(name);
                    if (trace) {
                        log.trace("Assign user to role " + name);
                    }
                    group.addMember(p);
                }
                catch (Exception e) {
                    log.debug("Failed to create principal: " + name, e);
                }
            } while (rs.next());
        }
        catch (NamingException ex) {
            le = new LoginException("Error looking up DataSource from: " + dsJndiName);
            le.initCause(ex);
            throw le;
        }
        catch (SQLException ex) {
            le = new LoginException("Query failed");
            le.initCause(ex);
            throw le;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {}
            }
            if (suspendResume) {
                TransactionDemarcationSupport.resumeAnyTransaction(tx);
                if (trace) {
                    log.trace("resumeAnyTransaction");
                }
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    static Properties loadProperties(String defaultsName, String propertiesName, Logger log) throws IOException {
        InputStream is;
        Properties bundle = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL defaultUrl = null;
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            defaultUrl = ucl.findResource(defaultsName);
            url = ucl.findResource(propertiesName);
            log.trace("findResource: " + url);
        }
        if (defaultUrl == null) {
            defaultUrl = loader.getResource(defaultsName);
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null && defaultUrl == null) {
            String msg = "No properties file: " + propertiesName + " or defaults: " + defaultsName + " found";
            throw new IOException(msg);
        }
        log.trace("Properties file=" + url + ", defaults=" + defaultUrl);
        Properties defaults = new Properties();
        if (defaultUrl != null) {
            try {
                is = defaultUrl.openStream();
                defaults.load(is);
                is.close();
                log.debug("Loaded defaults, users=" + defaults.keySet());
            }
            catch (Throwable e) {
                log.debug("Failed to load defaults", e);
            }
        }
        bundle = new Properties(defaults);
        if (url != null) {
            is = url.openStream();
            if (is == null) {
                throw new IOException("Properties file " + propertiesName + " not avilable");
            }
            bundle.load(is);
            is.close();
            log.debug("Loaded properties, users=" + bundle.keySet());
        }
        return bundle;
    }

    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            url = ucl.findResource(propertiesName);
            log.trace("findResource: " + url);
        }
        if (url == null) {
            url = loader.getResource(propertiesName);
        }
        if (url == null) {
            url = new URL(propertiesName);
        }
        log.trace("Properties file=" + url);
        Properties bundle = new Properties();
        if (url != null) {
            InputStream is = url.openStream();
            if (is == null) {
                throw new IOException("Properties file " + propertiesName + " not avilable");
            }
            bundle.load(is);
            is.close();
            log.debug("Loaded properties, users=" + bundle.keySet());
        }
        return bundle;
    }

    static void parseGroupMembers(Group group, String roles, AbstractServerLoginModule aslm) {
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Principal p = aslm.createIdentity(token);
                group.addMember(p);
            }
            catch (Exception e) {
                aslm.log.warn("Failed to create principal for: " + token, e);
            }
        }
    }
}

