/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.providers.MappingProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalToRoleMappingProvider
implements MappingProvider<Group> {
    private static final Logger log = Logger.getLogger(PrincipalToRoleMappingProvider.class);
    private static final String PRINCIPAL_ROLES_MAP = "principalRolesMap";
    private Map options = null;
    private Properties principalRoleMapProperties = null;

    @Override
    public void init(Map opt) {
        this.options = opt;
        if (log.isTraceEnabled()) {
            log.trace("Module Options=" + this.options);
        }
        if (this.options != null && this.options.containsKey(PRINCIPAL_ROLES_MAP)) {
            this.principalRoleMapProperties = (Properties)this.options.get(PRINCIPAL_ROLES_MAP);
        }
    }

    @Override
    public void performMapping(Map contextMap, Group mappedObject) {
        Set principals = (Set)contextMap.get("PrincipalsSet");
        for (Principal p : principals) {
            String[] tokens;
            String pname = p.getName().trim();
            boolean containsP = this.principalRoleMapProperties.containsKey(pname);
            log.trace("Principal:" + pname + " is contained in options map:" + containsP);
            if (!containsP) continue;
            String commaSeparatedRoles = this.principalRoleMapProperties.getProperty(pname);
            if (log.isTraceEnabled()) {
                log.trace("Principal:" + p.getName() + ":roles add=" + commaSeparatedRoles);
            }
            int len = (tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles)) != null ? tokens.length : 0;
            for (int i = 0; i < len; ++i) {
                mappedObject.addMember(MappingProviderUtil.instantiatePrincipal(p.getClass(), tokens[i]));
            }
        }
    }
}

