/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profile.repository;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.util.JBossObject;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
extends JBossObject
implements Profile {
    private String name;
    private String version;
    private DeploymentRepository repository;
    private volatile boolean hotdeployEnabled;

    public ProfileImpl(DeploymentRepository repository, String name) {
        this.name = name;
        this.repository = repository;
        this.log.info("Using repository:" + repository);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<String> getDeploymentNames() {
        return this.repository.getDeploymentNames();
    }

    @Override
    public Set<String> getDeploymentNames(Profile.DeploymentPhase phase) {
        return this.repository.getDeploymentNames(phase);
    }

    @Override
    public Set<String> getDeploymentNamesForType(String type) {
        return this.repository.getDeploymentNamesForType(type);
    }

    @Override
    public VirtualFile getRootFile(Profile.DeploymentPhase phase) throws Exception {
        URI uri = this.repository.getDeploymentURI(phase);
        VirtualFile root = VFS.getRoot(uri);
        return root;
    }

    @Override
    public Collection<DeploymentContext> getDeployments(Profile.DeploymentPhase phase) throws Exception {
        return this.repository.getDeployments(phase);
    }

    @Override
    public Collection<DeploymentContext> getDeployments() throws Exception {
        return this.repository.getDeployments();
    }

    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        Collection<ModificationInfo> modified = Collections.emptyList();
        if (this.hotdeployEnabled) {
            modified = this.repository.getModifiedDeployments();
        }
        return modified;
    }

    @Override
    public synchronized void enableModifiedDeploymentChecks(boolean flag) {
        this.hotdeployEnabled = flag;
    }

    @Override
    public void addDeployment(DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
        String name = d.getRelativePath();
        if (name.length() == 0) {
            name = d.getSimpleName();
        }
        this.repository.addDeployment(name, d, phase);
    }

    @Override
    public void updateDeployment(DeploymentContext d, Profile.DeploymentPhase phase) throws Exception {
        this.repository.updateDeployment(d.getRelativePath(), d, phase);
    }

    @Override
    public DeploymentContext getDeployment(String name, Profile.DeploymentPhase phase) throws Exception, NoSuchDeploymentException {
        return this.repository.getDeployment(name, phase);
    }

    @Override
    public DeploymentContext removeDeployment(String name, Profile.DeploymentPhase phase) throws Exception {
        return this.repository.removeDeployment(name, phase);
    }

    @Override
    public Map<String, Object> getConfig() {
        return null;
    }

    @Override
    public boolean hasDeployment(String name, Profile.DeploymentPhase phase) {
        try {
            this.getDeployment(name, phase);
            return true;
        }
        catch (NoSuchDeploymentException e) {
            return false;
        }
        catch (Exception e) {
            this.log.warn("getDeployment return exception", e);
            return false;
        }
    }
}

