/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.vfs;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.vfs.AssembledContext;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectoryHandler;
import org.jboss.virtual.plugins.context.vfs.AssembledFileHandler;
import org.jboss.virtual.plugins.context.vfs.ByteArrayHandler;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
import org.jboss.virtual.spi.VirtualFileHandler;

public class AssembledDirectory
extends VirtualFile {
    private AssembledDirectoryHandler directory;

    public AssembledDirectory(VirtualFileHandler handler) {
        super(handler);
        this.directory = (AssembledDirectoryHandler)handler;
    }

    public void addClass(Class clazz) {
        this.addClass(clazz.getName(), clazz.getClassLoader());
    }

    public void addClass(String className) {
        this.addClass(className, Thread.currentThread().getContextClassLoader());
    }

    public void addClass(String className, ClassLoader loader) {
        String resource = className.replace('.', '/') + ".class";
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        AssembledDirectory p = this.mkdirs(resource);
        p.addResource(resource, loader);
    }

    public AssembledDirectory mkdirs(String path) {
        String[] pkgs = path.split("/");
        AssembledDirectoryHandler dir = this.directory;
        for (int i = 0; i < pkgs.length - 1; ++i) {
            AssembledDirectoryHandler next = (AssembledDirectoryHandler)dir.getChild(pkgs[i]);
            if (next == null) {
                try {
                    next = new AssembledDirectoryHandler((AssembledContext)dir.getVFSContext(), dir, pkgs[i]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                dir.addChld(next);
            }
            dir = next;
        }
        AssembledDirectory p = (AssembledDirectory)dir.getVirtualFile();
        return p;
    }

    public void addResources(Class baseResource, String[] includes, String[] excludes) {
        String resource = baseResource.getName().replace('.', '/') + ".class";
        this.addResources(resource, includes, excludes);
    }

    public void addResources(String baseResource, String[] includes, String[] excludes) {
        this.addResources(baseResource, includes, excludes, Thread.currentThread().getContextClassLoader());
    }

    public void addResources(String baseResource, final String[] includes, final String[] excludes, ClassLoader loader) {
        URL url = loader.getResource(baseResource);
        if (url == null) {
            throw new RuntimeException("Could not find baseResource: " + baseResource);
        }
        String urlString = url.toString();
        int idx = urlString.lastIndexOf(baseResource);
        urlString = urlString.substring(0, idx);
        try {
            url = new URL(urlString);
            VirtualFile parent = VFS.getRoot(url);
            VisitorAttributes va = new VisitorAttributes();
            va.setLeavesOnly(true);
            SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
            va.setRecurseFilter(noJars);
            VirtualFileFilter filter = new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    boolean matched = false;
                    String path = file.getPathName();
                    for (String include : includes) {
                        if (!AssembledDirectory.antMatch(path, include)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return false;
                    }
                    if (excludes != null) {
                        for (String exclude : excludes) {
                            if (!AssembledDirectory.antMatch(path, exclude)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
            FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
            parent.visit(visitor);
            List<VirtualFile> files = visitor.getMatched();
            for (VirtualFile vf : files) {
                this.mkdirs(vf.getPathName()).addChild(vf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Pattern getPattern(String matcher) {
        matcher = matcher.replace(".", "\\.");
        matcher = matcher.replace("*", ".*");
        matcher = matcher.replace("?", ".{1}");
        return Pattern.compile(matcher);
    }

    public static boolean antMatch(String path, String expression) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (expression.endsWith("/")) {
            expression = expression + "**";
        }
        String[] paths = path.split("/");
        String[] expressions = expression.split("/");
        int x = 0;
        int p = 0;
        Pattern pattern = AssembledDirectory.getPattern(expressions[0]);
        for (p = 0; p < paths.length && x < expressions.length; ++p) {
            String element;
            if (expressions[x].equals("**")) {
                while (++x < expressions.length && expressions[x].equals("**")) {
                }
                if (x == expressions.length) {
                    return true;
                }
                pattern = AssembledDirectory.getPattern(expressions[x]);
            }
            if (pattern.matcher(element = paths[p]).matches()) {
                if (++x >= expressions.length) continue;
                pattern = AssembledDirectory.getPattern(expressions[x]);
                continue;
            }
            if (x > 0 && expressions[x - 1].equals("**")) continue;
            return false;
        }
        if (p < paths.length) {
            return false;
        }
        return x >= expressions.length;
    }

    public VirtualFile addChild(VirtualFile vf) {
        return this.directory.addChld(vf.getHandler()).getVirtualFile();
    }

    public VirtualFile addChild(VirtualFile vf, String newName) {
        try {
            AssembledFileHandler handler = new AssembledFileHandler((AssembledContext)this.directory.getVFSContext(), this.directory, newName, vf.getHandler());
            this.directory.addChld(handler);
            return handler.getVirtualFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addResource(String resource) {
        return this.addResource(resource, Thread.currentThread().getContextClassLoader());
    }

    public VirtualFile addResource(String resource, String newName) {
        return this.addResource(resource, Thread.currentThread().getContextClassLoader(), newName);
    }

    public VirtualFile addResource(String resource, ClassLoader loader) {
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        return this.addResource(url);
    }

    public VirtualFile addResource(URL url) {
        try {
            VirtualFile vf = VFS.getRoot(url);
            return this.addChild(vf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addResource(String resource, ClassLoader loader, String newName) {
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        try {
            VirtualFile vf = VFS.getRoot(url);
            return this.addChild(vf, newName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addBytes(byte[] bytes, String name) {
        ByteArrayHandler handler = null;
        try {
            handler = new ByteArrayHandler((AssembledContext)this.directory.getVFSContext(), this.directory, name, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.directory.addChld(handler);
        return handler.getVirtualFile();
    }

    public AssembledDirectory mkdir(String name) {
        AssembledDirectoryHandler handler = null;
        try {
            handler = new AssembledDirectoryHandler((AssembledContext)this.directory.getVFSContext(), this.directory, name);
            this.directory.addChld(handler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new AssembledDirectory(handler);
    }
}

