/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.core.RoleSource;
import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.ServerHandlerChain;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerDelegateJAXRPC
extends ServerHandlerDelegate
implements RoleSource {
    private static Logger log = Logger.getLogger(HandlerDelegateJAXRPC.class);
    private ServerHandlerChain preHandlerChain;
    private ServerHandlerChain jaxrpcHandlerChain;
    private ServerHandlerChain postHandlerChain;
    Set<QName> headers = new HashSet<QName>();
    Set<String> roles = new HashSet<String>();

    public HandlerDelegateJAXRPC(ServerEndpointMetaData sepMetaData) {
        super(sepMetaData);
        sepMetaData.registerConfigObserver(this);
    }

    @Override
    protected HandlerMetaData.HandlerType[] getHandlerTypeOrder() {
        return new HandlerMetaData.HandlerType[]{HandlerMetaData.HandlerType.PRE, HandlerMetaData.HandlerType.ENDPOINT, HandlerMetaData.HandlerType.POST};
    }

    @Override
    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        if (!this.isInitialized()) {
            this.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.PRE);
            this.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.ENDPOINT);
            this.initHandlerChain(sepMetaData, HandlerMetaData.HandlerType.POST);
            this.setInitialized(true);
        }
        boolean status = true;
        ServerHandlerChain handlerChain = null;
        if (type == HandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        if (handlerChain != null) {
            status = handlerChain.handleRequest(msgContext);
        }
        return status;
    }

    @Override
    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        boolean status;
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == HandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        boolean bl = status = handlerChain != null ? handlerChain.handleResponse(msgContext) : true;
        if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            XOPContext.visitAndRestoreXOPData();
        }
        return status;
    }

    @Override
    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type, Exception ex) {
        boolean status;
        SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
        ServerHandlerChain handlerChain = null;
        if (type == HandlerMetaData.HandlerType.PRE) {
            handlerChain = this.preHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            handlerChain = this.jaxrpcHandlerChain;
        } else if (type == HandlerMetaData.HandlerType.POST) {
            handlerChain = this.postHandlerChain;
        }
        boolean bl = status = handlerChain != null ? handlerChain.handleFault(msgContext) : true;
        if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            XOPContext.visitAndRestoreXOPData();
        }
        return status;
    }

    @Override
    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
    }

    private void initHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        HashSet<String> handlerRoles = new HashSet<String>();
        ArrayList<HandlerInfo> hInfos = new ArrayList<HandlerInfo>();
        for (HandlerMetaData handlerMetaData : sepMetaData.getHandlerMetaData(type)) {
            HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
            handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
            HashMap<String, Object> hConfig = new HashMap<String, Object>();
            for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams()) {
                hConfig.put(param.getParamName(), param.getParamValue());
            }
            Set<QName> headers = jaxrpcMetaData.getSoapHeaders();
            QName[] headerArr = new QName[headers.size()];
            headers.toArray(headerArr);
            Class hClass = jaxrpcMetaData.getHandlerClass();
            hConfig.put(HandlerMetaData.HandlerType.class.getName(), (Object)jaxrpcMetaData.getHandlerType());
            HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
            if (log.isDebugEnabled()) {
                log.debug("Adding server side handler to service '" + sepMetaData.getPortName() + "': " + info);
            }
            hInfos.add(info);
        }
        this.initHandlerChain(sepMetaData, hInfos, handlerRoles, type);
    }

    private void initHandlerChain(ServerEndpointMetaData sepMetaData, List<HandlerInfo> hInfos, Set<String> handlerRoles, HandlerMetaData.HandlerType type) {
        if (log.isDebugEnabled()) {
            log.debug("Init handler chain with [" + hInfos.size() + "] handlers");
        }
        ServerHandlerChain handlerChain = new ServerHandlerChain(hInfos, handlerRoles, type);
        if (type == HandlerMetaData.HandlerType.PRE) {
            this.preHandlerChain = handlerChain;
        } else if (type == HandlerMetaData.HandlerType.ENDPOINT) {
            this.jaxrpcHandlerChain = handlerChain;
        } else if (type == HandlerMetaData.HandlerType.POST) {
            this.postHandlerChain = handlerChain;
        }
        if (handlerChain.getState() == 1) {
            handlerChain.init(null);
        }
        handlerChain.pullHeaders(this.headers);
        Collections.addAll(this.roles, handlerChain.getRoles());
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public Set<QName> getHeaders() {
        return this.headers;
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

