/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMetaDataBuilder {
    private Class seiClass = null;
    private ToolsEndpointMetaData tmd = null;
    private String targetNamespace = null;
    private Map<String, List<Configuration.OperationConfig>> operationMap = null;
    private Map<String, Integer> operationNameCount = new HashMap<String, Integer>();

    public ReflectiveMetaDataBuilder(ToolsEndpointMetaData tmd) {
        this.seiClass = tmd.getServiceEndpointInterface();
        this.checkServiceEndpointInterface();
        this.targetNamespace = tmd.getPortName().getNamespaceURI();
        this.tmd = tmd;
    }

    public void setOperationMap(Map<String, List<Configuration.OperationConfig>> operationMap) {
        this.operationMap = operationMap;
    }

    public ToolsEndpointMetaData generate() {
        this.generateOperationMetaData(this.seiClass.getMethods());
        return this.tmd;
    }

    private void checkServiceEndpointInterface() {
        if (this.seiClass == null) {
            throw new IllegalArgumentException("Illegal Null Argument: seiClass");
        }
        if (!this.seiClass.isInterface()) {
            throw new IllegalArgumentException("Illegal seiClass : not an interface");
        }
        if (!Remote.class.isAssignableFrom(this.seiClass)) {
            throw new WSException("A service endpoint interface MUST extend java.rmi.Remote: " + this.seiClass.getName());
        }
    }

    private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om) {
        WSDLUtils.getInstance();
        String exname = WSDLUtils.getJustClassName(exType);
        QName xmlName = new QName(this.tmd.typeNamespace, exname);
        FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
        return fm;
    }

    private Configuration.OperationConfig getOperationConfig(String name, Class<?>[] types) {
        if (this.operationMap == null) {
            return null;
        }
        List<Configuration.OperationConfig> configs = this.operationMap.get(name);
        if (configs == null) {
            return null;
        }
        for (Configuration.OperationConfig config : configs) {
            int i;
            if (config.params.size() != types.length) continue;
            for (i = 0; i < types.length; ++i) {
                String typeName = config.params.get((int)i).javaType;
                if (!JavaUtils.getSourceName(types[i]).equals(typeName)) break;
            }
            if (i != types.length) continue;
            return config;
        }
        return null;
    }

    private void generateOperationMetaData(Method[] marr) {
        if (marr == null) {
            throw new WSException("Number of methods in the seiClass is zero");
        }
        for (Method m : marr) {
            String methodname = m.getName();
            Class<?>[] paramTypes = m.getParameterTypes();
            int len = paramTypes.length;
            OperationMetaData om = this.getOperationMetaData(m);
            Configuration.OperationConfig opc = this.getOperationConfig(methodname, m.getParameterTypes());
            if (opc != null) {
                om.setOneWay(opc.isOneWay);
            }
            ParameterMetaData wrappedParameter = null;
            ArrayList<WrappedParameter> wrappedParameters = null;
            if (om.isDocumentWrapped()) {
                QName xmlName;
                QName xmlType = xmlName = new QName(this.tmd.typeNamespace, om.getQName().getLocalPart());
                wrappedParameter = new ParameterMetaData(om, xmlName, xmlType, null);
                wrappedParameters = new ArrayList<WrappedParameter>(len);
                wrappedParameter.setWrappedParameters(wrappedParameters);
                om.addParameter(wrappedParameter);
                if (!om.isOneWay()) {
                    xmlType = xmlName = new QName(this.tmd.typeNamespace, om.getResponseName().getLocalPart());
                    ParameterMetaData retMetaData = new ParameterMetaData(om, xmlName, xmlType, null);
                    retMetaData.setWrappedParameters(new ArrayList<WrappedParameter>(0));
                    om.setReturnParameter(retMetaData);
                }
            }
            for (int i = 0; i < len; ++i) {
                Class<?> paramType = paramTypes[i];
                if (Remote.class.isAssignableFrom(paramType)) {
                    throw new WSException("Param Type " + paramType.getName() + " should not extend java.rmi.Remote");
                }
                if (om.isDocumentWrapped() && !this.isHeaderParameter(opc, i)) {
                    QName xmlName = this.getXmlName(paramType, opc, i, null);
                    wrappedParameters.add(new WrappedParameter(xmlName, paramType.getName(), this.convertToProperty(xmlName.getLocalPart()), i));
                    continue;
                }
                om.addParameter(this.getParameterMetaData(paramType, om, opc, i));
            }
            Class<?> returnType = m.getReturnType();
            if (Void.TYPE != returnType) {
                if (Remote.class.isAssignableFrom(returnType)) {
                    throw new WSException("Return Type " + returnType.getName() + " should not extend java.rmi.Remote");
                }
                if (om.isDocumentWrapped()) {
                    QName name = this.getReturnXmlName(opc, null);
                    WrappedParameter wrapped = new WrappedParameter(name, returnType.getName(), this.convertToProperty(name.getLocalPart()), -1);
                    ParameterMetaData retMetaData = om.getReturnParameter();
                    retMetaData.getWrappedParameters().add(wrapped);
                } else {
                    om.setReturnParameter(this.getParameterMetaDataForReturnType(returnType, om, opc));
                }
            }
            if (om.isDocumentWrapped()) {
                ParameterWrapping.generateWrapper(wrappedParameter, false);
                if (!om.isOneWay()) {
                    ParameterWrapping.generateWrapper(om.getReturnParameter(), false);
                }
            }
            Class<?>[] exceptionTypes = m.getExceptionTypes();
            boolean remoteExceptionFound = false;
            if (exceptionTypes != null) {
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    if (RemoteException.class.isAssignableFrom(exceptionTypes[i])) {
                        remoteExceptionFound = true;
                        continue;
                    }
                    om.addFault(this.getFaultMetaData(exceptionTypes[i], om));
                }
            }
            if (!remoteExceptionFound) {
                throw new WSException(m.getName() + " does not throw RemoteException.");
            }
            om.assertDocumentBare();
            this.tmd.addOperation(om);
        }
    }

    private OperationMetaData getOperationMetaData(Method m) {
        String methodName = m.getName();
        int count = 0;
        if (this.operationNameCount.containsKey(methodName)) {
            count = this.operationNameCount.get(methodName);
        }
        this.operationNameCount.put(methodName, ++count);
        String localName = count > 1 ? methodName + count : methodName;
        OperationMetaData om = new OperationMetaData(this.tmd, new QName(this.targetNamespace, localName), methodName);
        om.setSOAPAction("");
        return om;
    }

    private boolean isHeaderParameter(Configuration.OperationConfig config, int index) {
        if (config == null) {
            return false;
        }
        return config.params.get((int)index).header;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, Configuration.OperationConfig config, int index) {
        boolean holder;
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getXmlName(type, config, index, om.isDocumentBare() ? om.getQName().getLocalPart() : null);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        pm.setInHeader(this.isHeaderParameter(config, index));
        String mode = null;
        if (config != null) {
            mode = config.params.get((int)index).mode;
        }
        if (holder = Holder.class.isAssignableFrom(type)) {
            pm.setJavaTypeName(HolderUtils.getValueType(type).getName());
            if (mode != null) {
                if (mode.equals("OUT")) {
                    pm.setMode(ParameterMode.OUT);
                } else if (mode.equals("INOUT")) {
                    pm.setMode(ParameterMode.INOUT);
                }
            } else {
                pm.setMode(ParameterMode.INOUT);
            }
        }
        return pm;
    }

    private QName getXmlName(Class type, Configuration.OperationConfig config, int index, String defaultName) {
        QName name;
        if (config != null && (name = config.params.get((int)index).xmlName) != null) {
            if ("".equals(name.getNamespaceURI())) {
                name = new QName(this.tmd.typeNamespace, name.getLocalPart());
            }
            return name;
        }
        if (defaultName == null) {
            defaultName = this.getDefaultName(type) + "_" + (index + 1);
        }
        QName xmlName = new QName(this.tmd.typeNamespace, defaultName);
        return xmlName;
    }

    private QName getReturnXmlName(Configuration.OperationConfig config, String defaultName) {
        QName name;
        if (config != null && (name = config.returnXmlName) != null) {
            if ("".equals(name.getNamespaceURI())) {
                name = new QName(this.tmd.typeNamespace, name.getLocalPart());
            }
            return name;
        }
        if (defaultName == null) {
            defaultName = "result";
        }
        return new QName(this.tmd.typeNamespace, defaultName);
    }

    private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, Configuration.OperationConfig config) {
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getReturnXmlName(config, om.isDocumentBare() ? om.getResponseName().getLocalPart() : null);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        return pm;
    }

    private String getDefaultName(Class javaClass) {
        String name = "";
        WSDLUtils utils = WSDLUtils.getInstance();
        if (Holder.class.isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        name = javaClass.isArray() ? utils.getMessagePartForArray(javaClass) : WSDLUtils.getJustClassName(javaClass);
        return name;
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuilder builder = new StringBuilder(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }
}

