/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.Arrays;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ExceptionTable;

public class BasicBlock {
    public int position;
    public int stackTop;
    public int[] stackTypes;
    public int[] localsTypes;
    public Object[] stackData;
    public Object[] localsData;

    private BasicBlock(int pos) {
        this.position = pos;
    }

    public void set(int st, int[] stypes, Object[] sdata, int[] ltypes, Object[] ldata) throws BadBytecode {
        if (this.stackTypes == null) {
            this.stackTop = st;
            this.stackTypes = BasicBlock.copy(stypes);
            this.stackData = BasicBlock.copy(sdata);
            this.localsTypes = BasicBlock.copy(ltypes);
            this.localsData = BasicBlock.copy(ldata);
        } else {
            if (st != this.stackTop) {
                throw new BadBytecode("verification failure");
            }
            int n = ltypes.length;
            for (int i = 0; i < n; ++i) {
                if (ltypes[i] != this.localsTypes[i]) {
                    this.localsTypes[i] = -1;
                    this.localsData[i] = null;
                    continue;
                }
                if (ltypes[i] == 7 && ldata[i].equals(this.localsData[i])) continue;
            }
        }
    }

    private static int[] copy(int[] a) {
        int[] b = new int[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    private static Object[] copy(Object[] a) {
        Object[] b = new Object[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static BasicBlock find(BasicBlock[] blocks, int pos) throws BadBytecode {
        int n = blocks.length;
        for (int i = 0; i < n; ++i) {
            if (blocks[i].position != pos) continue;
            return blocks[i];
        }
        throw new BadBytecode("no basic block: " + pos);
    }

    public static BasicBlock[] makeBlocks(CodeIterator ci, ExceptionTable et) throws BadBytecode {
        ci.begin();
        int[] targets = new int[16];
        int size = 0;
        while (ci.hasNext()) {
            int index = ci.next();
            int op = ci.byteAt(index);
            if (153 <= op && op <= 166 || op == 198 || op == 199) {
                targets = BasicBlock.add(targets, size++, index + ci.s16bitAt(index + 1));
                continue;
            }
            if (167 <= op && op <= 171) {
                switch (op) {
                    case 167: {
                        targets = BasicBlock.add(targets, size++, index + ci.s16bitAt(index + 1));
                        break;
                    }
                    case 168: 
                    case 169: {
                        throw new BadBytecode("jsr/ret at " + index);
                    }
                    case 170: {
                        int p;
                        int pos = (index & 0xFFFFFFFC) + 4;
                        targets = BasicBlock.add(targets, size++, index + ci.s32bitAt(pos));
                        int low = ci.s32bitAt(pos + 4);
                        int high = ci.s32bitAt(pos + 8);
                        int n = p + (high - low + 1) * 4;
                        for (p = pos + 12; p < n; p += 4) {
                            targets = BasicBlock.add(targets, size++, index + ci.s32bitAt(p));
                        }
                        break;
                    }
                    case 171: {
                        int p;
                        int pos = (index & 0xFFFFFFFC) + 4;
                        targets = BasicBlock.add(targets, size++, index + ci.s32bitAt(pos));
                        int n = p + ci.s32bitAt(pos + 4) * 8;
                        for (p = pos + 8 + 4; p < n; p += 8) {
                            targets = BasicBlock.add(targets, size++, index + ci.s32bitAt(p));
                        }
                        break;
                    }
                }
                continue;
            }
            if (op == 200) {
                targets = BasicBlock.add(targets, size++, index + ci.s32bitAt(index + 1));
                continue;
            }
            if (op != 201) continue;
            throw new BadBytecode("jsr_w at " + index);
        }
        if (et != null) {
            int i = et.size();
            while (--i >= 0) {
                targets = BasicBlock.add(targets, size++, et.startPc(i));
                targets = BasicBlock.add(targets, size++, et.handlerPc(i));
            }
        }
        return BasicBlock.trimArray(targets);
    }

    private static int[] add(int[] targets, int size, int value) {
        if (targets.length >= size) {
            int[] a = new int[size << 1];
            System.arraycopy(targets, 0, a, 0, targets.length);
            targets = a;
        }
        targets[size++] = value;
        return targets;
    }

    private static BasicBlock[] trimArray(int[] targets) {
        int size = targets.length;
        Arrays.sort(targets);
        int s = 0;
        int t0 = 0;
        for (int i = 0; i < size; ++i) {
            int t = targets[i];
            if (t == t0) continue;
            ++s;
            t0 = t;
        }
        BasicBlock[] results = new BasicBlock[s + 1];
        results[0] = new BasicBlock(0);
        t0 = 0;
        int j = 1;
        for (int i = 0; i < size; ++i) {
            int t = targets[i];
            if (t == t0) continue;
            BasicBlock b = new BasicBlock(t);
            results[j++] = b;
            t0 = t;
        }
        return results;
    }
}

