/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class ChannelException
extends Exception {
    private static final boolean IS_JAVA_13;
    private Throwable _cause;

    public ChannelException() {
    }

    public ChannelException(String reason) {
        super(reason);
    }

    public ChannelException(String reason, Throwable cause) {
        super(reason);
        this._cause = cause;
    }

    public String toString() {
        return "ChannelException: " + this.getMessage();
    }

    public Throwable getCause() {
        return this._cause;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (IS_JAVA_13) {
                this.printCauseStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (IS_JAVA_13) {
                this.printCauseStackTrace(pw);
            }
        }
    }

    private void printCauseStackTrace(PrintStream ps) {
        if (this._cause != null) {
            ps.print("Caused by: ");
            this._cause.printStackTrace(ps);
        }
    }

    private void printCauseStackTrace(PrintWriter pw) {
        if (this._cause != null) {
            pw.print("Caused by: ");
            this._cause.printStackTrace(pw);
        }
    }

    static {
        String javaSpecVersion = System.getProperty("java.specification.version");
        StringTokenizer tokenizer = new StringTokenizer(javaSpecVersion, ".");
        int majorVersion = Integer.parseInt(tokenizer.nextToken());
        int minorVersion = Integer.parseInt(tokenizer.nextToken());
        IS_JAVA_13 = majorVersion == 1 && minorVersion == 3;
    }
}

