/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class CountDown
implements Sync {
    protected final int initialCount_;
    protected int count_;

    public CountDown(int count) {
        this.count_ = this.initialCount_ = count;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            while (this.count_ > 0) {
                this.wait();
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDown countDown = this;
        synchronized (countDown) {
            if (this.count_ <= 0) {
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            do {
                this.wait(waitTime);
                if (this.count_ > 0) continue;
                boolean bl = true;
                return bl;
            } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
            boolean bl = false;
            return bl;
        }
    }

    public synchronized void release() {
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public int initialCount() {
        return this.initialCount_;
    }

    public synchronized int currentCount() {
        return this.count_;
    }
}

