/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.collection.CachedListAbstract;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.util.NestedRuntimeException;

public class CachedListImpl
extends CachedListAbstract
implements List {
    protected TreeCacheAop cache_;
    protected AbstractCollectionInterceptor interceptor_;

    public CachedListImpl(TreeCacheAop cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    protected DataNode getNode() {
        try {
            return this.cache_.get(this.getFqn());
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(int index) {
        this.checkIndex(index);
        try {
            return this.cache_.getObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private void checkIndex(int i) {
        if (this.size() == 0) {
            return;
        }
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound at CachedListImpl(). Index is " + i + " but size is " + this.size());
        }
    }

    private void checkArgument(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    public int size() {
        DataNode node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public Object set(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            Object oldValue = this.get(index);
            return this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void add(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            for (int i = this.size(); i > index; --i) {
                Object obj = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i - 1)));
                this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i)), obj);
            }
            this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public int indexOf(Object o) {
        this.checkArgument(o);
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        this.checkArgument(o);
        int index = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    public Object remove(int index) {
        try {
            this.checkIndex(index);
            int size = this.size();
            Object result = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(index)));
            if (size == index + 1) {
                return result;
            }
            for (int i = index; i < size - 1; ++i) {
                Object obj = this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i + 1)));
                this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), Integer.toString(i)), obj);
            }
            return result;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int current = -1;

            public boolean hasNext() {
                if (CachedListImpl.this.size() == 0) {
                    return false;
                }
                if (this.current > CachedListImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                return this.current < CachedListImpl.this.size() - 1;
            }

            public Object next() {
                if (this.current == CachedListImpl.this.size()) {
                    throw new IllegalStateException("CachedSetImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                }
                try {
                    return CachedListImpl.this.cache_.getObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(++this.current)));
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }

            public void remove() {
                try {
                    int size = CachedListImpl.this.size();
                    if (CachedListImpl.this.size() == 0) {
                        return;
                    }
                    if (this.current == CachedListImpl.this.size()) {
                        throw new IllegalStateException("CachedSetImpl.iterator.remove().  Cursor position " + this.current + " is greater than the size " + CachedListImpl.this.size());
                    }
                    if (this.current < size - 1) {
                        Object last = CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(this.current)));
                        for (int i = this.current + 1; i < size; ++i) {
                            last = CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(i)));
                            CachedListImpl.this.cache_.putObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(i - 1)), last);
                        }
                    } else {
                        CachedListImpl.this.cache_.removeObject(AopUtil.constructFqn(CachedListImpl.this.getFqn(), Integer.toString(this.current)));
                    }
                    --this.current;
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex + " but size() =" + this.size());
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex (" + fromIndex + ") must be less than toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new LinkedList();
        }
        return new MyCachedSubListImpl(this, fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return new MyListIterator(this, 0);
    }

    public ListIterator listIterator(int index) {
        return new MyListIterator(this, index);
    }

    public static class MyCachedSubListImpl
    extends CachedListAbstract
    implements List {
        private List backStore_;
        private int fromIndex_;
        private int toIndex_;

        MyCachedSubListImpl(List backStore, int fromIndex, int toIndex) {
            this.backStore_ = backStore;
            this.fromIndex_ = fromIndex;
            this.toIndex_ = toIndex;
        }

        public int size() {
            int size = this.backStore_.size();
            if (size > this.toIndex_) {
                size = this.toIndex_;
            }
            return size -= this.fromIndex_;
        }

        public Iterator iterator() {
            return new Iterator(this){
                protected int current;
                protected Iterator iter_;
                private final /* synthetic */ MyCachedSubListImpl this$0;
                {
                    this.this$0 = this$0;
                    this.current = -1;
                    this.iter_ = this.initializeIter();
                }

                private Iterator initializeIter() {
                    Iterator<E> iter = MyCachedSubListImpl.access$000(this.this$0).iterator();
                    for (int looper = 0; looper < MyCachedSubListImpl.access$100(this.this$0); ++looper) {
                        if (!iter.hasNext()) continue;
                        iter.next();
                    }
                    return iter;
                }

                public boolean hasNext() {
                    int size = this.this$0.size();
                    if (size == 0) {
                        return false;
                    }
                    if (this.current > size) {
                        throw new IllegalStateException("CachedSetImpl.MyCachedSubListImpl.iterator.hasNext().  Cursor position " + this.current + " is greater than the size " + this.this$0.size());
                    }
                    return this.current < this.this$0.size() - 1;
                }

                public Object next() {
                    if (this.current == this.this$0.size()) {
                        throw new IllegalStateException("CachedSetImpl.MyCachedSubListImpl.iterator.next().  Cursor position " + this.current + " is greater than the size " + this.this$0.size());
                    }
                    ++this.current;
                    try {
                        return this.iter_.next();
                    }
                    catch (Exception e) {
                        throw new NestedRuntimeException((Throwable)e);
                    }
                }

                public void remove() {
                    this.iter_.remove();
                    --this.current;
                }
            };
        }

        public Object get(int index) {
            this.checkIndex(index);
            return this.backStore_.get(index + this.fromIndex_);
        }

        public Object set(int index, Object element) {
            this.checkIndex(index);
            return this.backStore_.set(index + this.fromIndex_, element);
        }

        public void add(int index, Object element) {
            this.backStore_.add(index + this.fromIndex_, element);
        }

        public Object remove(int index) {
            return this.backStore_.remove(index + this.fromIndex_);
        }

        public int indexOf(Object o) {
            int index = this.backStore_.indexOf(o);
            index = index < this.fromIndex_ || index >= this.toIndex_ ? -1 : (index -= this.fromIndex_);
            return index;
        }

        public int lastIndexOf(Object o) {
            int index = this.backStore_.lastIndexOf(o);
            index = index < this.fromIndex_ || index >= this.toIndex_ ? -1 : (index -= this.fromIndex_);
            return index;
        }

        public ListIterator listIterator() {
            return new MyListIterator(this, 0);
        }

        public ListIterator listIterator(int index) {
            return new MyListIterator(this, index);
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > this.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex + " but size() =" + this.size());
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex (" + fromIndex + ") must be less than toIndex(" + toIndex + ")");
            }
            if (fromIndex == toIndex) {
                return new LinkedList();
            }
            return new MyCachedSubListImpl(this, fromIndex, toIndex);
        }

        private void checkIndex(int i) {
            if (this.size() == 0) {
                return;
            }
            if (i < 0 || i >= this.size()) {
                throw new IndexOutOfBoundsException("Index out of bound at CachedListImpl(). Index is " + i + " but size is " + this.size());
            }
        }

        static /* synthetic */ List access$000(MyCachedSubListImpl x0) {
            return x0.backStore_;
        }

        static /* synthetic */ int access$100(MyCachedSubListImpl x0) {
            return x0.fromIndex_;
        }
    }

    protected static class MyListIterator
    implements ListIterator {
        protected int index = 0;
        protected List list_;

        public MyListIterator(List list, int index) {
            this.list_ = list;
            if (index < 0 || index >= this.list_.size()) {
                throw new IndexOutOfBoundsException("CachedListImpl: MyListIterator construction.  Index is out of bound : " + index);
            }
            this.index = index;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            try {
                int size = this.list_.size();
                if (size == 0) {
                    return;
                }
                if (this.previousIndex() == size) {
                    throw new IllegalStateException("CachedSetImpl.MyListIterator.remove().  Cursor position " + this.index + " is greater than the size " + size);
                }
                if (this.previousIndex() < size) {
                    this.list_.remove(this.previousIndex());
                    --this.index;
                }
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public boolean hasNext() {
            return this.index != this.list_.size() - 1;
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            if (this.index == this.list_.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.list_.get(this.index - 1);
        }

        public Object previous() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return this.list_.get(this.index);
        }

        public void add(Object o) {
            int size = this.list_.size();
            if (size == 0) {
                return;
            }
            if (this.previousIndex() == size) {
                throw new IllegalStateException("CachedSetImpl.MyListIterator.add().  Cursor position " + this.index + " is greater than the size " + size);
            }
            if (this.previousIndex() < size) {
                this.list_.add(this.previousIndex(), o);
            }
        }

        public void set(Object o) {
            int size = this.list_.size();
            if (size == 0) {
                return;
            }
            if (this.previousIndex() == size) {
                throw new IllegalStateException("CachedSetImpl.MyListIterator.set().  Cursor position " + this.index + " is greater than the size " + size);
            }
            if (this.previousIndex() < size) {
                this.list_.set(this.previousIndex(), o);
            }
        }
    }
}

