/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.collection.AbstractCollectionInterceptor;
import org.jboss.cache.aop.util.AopUtil;
import org.jboss.util.NestedRuntimeException;

public class CachedMapImpl
implements Map {
    protected TreeCacheAop cache_;
    protected AbstractCollectionInterceptor interceptor_;

    protected CachedMapImpl(TreeCacheAop cache, AbstractCollectionInterceptor interceptor) {
        this.cache_ = cache;
        this.interceptor_ = interceptor;
    }

    protected Fqn getFqn() {
        return this.interceptor_.getFqn();
    }

    protected DataNode getNode() {
        try {
            return this.cache_.get(this.getFqn());
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(Object key) {
        try {
            return this.cache_.getObject(AopUtil.constructFqn(this.getFqn(), key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object put(Object key, Object value) {
        try {
            return this.cache_.putObject(AopUtil.constructFqn(this.getFqn(), key), value);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        try {
            return this.cache_.removeObject(AopUtil.constructFqn(this.getFqn(), key));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void clear() {
        ArrayList list = new ArrayList(this.keySet());
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    public int size() {
        DataNode node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object object) {
        Map children = this.getNode().getChildren();
        return children == null ? false : children.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    public Set entrySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Map children = CachedMapImpl.this.getNode().getChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Map children = CachedMapImpl.this.getNode().getChildren();
                Iterator<Object> i = children == null ? Collections.EMPTY_LIST.iterator() : children.keySet().iterator();
                return new Iterator(this, i){
                    Object lastKey;
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = this.val$i.next();
                        return 1.access$000(this.this$1).new Entry(this.lastKey);
                    }

                    public void remove() {
                        1.access$100(this.this$1).remove(this.lastKey);
                    }
                };
            }

            static /* synthetic */ CachedMapImpl access$000(1 x0) {
                return x0.CachedMapImpl.this;
            }

            static /* synthetic */ CachedMapImpl access$100(1 x0) {
                return x0.map;
            }
        };
    }

    public Collection values() {
        final CachedMapImpl map = this;
        return new AbstractCollection(){

            public int size() {
                Map children = CachedMapImpl.this.getNode().getChildren();
                return children == null ? 0 : children.size();
            }

            public void clear() {
                map.clear();
            }

            public Iterator iterator() {
                Map children = CachedMapImpl.this.getNode().getChildren();
                Iterator<Object> i = children == null ? Collections.EMPTY_LIST.iterator() : children.keySet().iterator();
                return new Iterator(this, i){
                    Object lastKey;
                    private final /* synthetic */ Iterator val$i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$i = val$i;
                    }

                    public boolean hasNext() {
                        return this.val$i.hasNext();
                    }

                    public Object next() {
                        try {
                            this.lastKey = this.val$i.next();
                            return 3.access$200(this.this$1).cache_.getObject(AopUtil.constructFqn(3.access$200(this.this$1).getFqn(), this.lastKey));
                        }
                        catch (CacheException e) {
                            throw new NestedRuntimeException((Throwable)((Object)e));
                        }
                    }

                    public void remove() {
                        3.access$300(this.this$1).remove(this.lastKey);
                    }
                };
            }

            static /* synthetic */ CachedMapImpl access$200(3 x0) {
                return x0.CachedMapImpl.this;
            }

            static /* synthetic */ CachedMapImpl access$300(3 x0) {
                return x0.map;
            }
        };
    }

    public Set keySet() {
        Map children = this.getNode().getChildren();
        return children == null ? Collections.EMPTY_SET : children.keySet();
    }

    public int hashCode() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            Object value = entry.getValue();
            if (value != null) {
                if (map.get(entry.getKey()) != null && map.containsKey(entry.getKey())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set set = this.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            buf.append("[" + key).append(", ").append(this.get(key)).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    protected class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            try {
                return CachedMapImpl.this.cache_.getObject(AopUtil.constructFqn(CachedMapImpl.this.getFqn(), this.key));
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public Object setValue(Object value) {
            try {
                return CachedMapImpl.this.cache_.putObject(AopUtil.constructFqn(CachedMapImpl.this.getFqn(), this.key), value);
            }
            catch (Exception e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }
}

