/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.Region;

public class EvictionTimerTask
extends TimerTask {
    private Log log = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$EvictionTimerTask == null ? (class$org$jboss$cache$eviction$EvictionTimerTask = EvictionTimerTask.class$("org.jboss.cache.eviction.EvictionTimerTask")) : class$org$jboss$cache$eviction$EvictionTimerTask));
    private final Set processedRegions = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$org$jboss$cache$eviction$EvictionTimerTask;

    public void addRegionToProcess(Region region) {
        this.processedRegions.add(region);
    }

    public void removeRegionToProcess(Region region) {
        this.processedRegions.remove(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Set set = this.processedRegions;
        synchronized (set) {
            Iterator it = this.processedRegions.iterator();
            while (it.hasNext()) {
                Region region = (Region)it.next();
                EvictionPolicy policy = region.getEvictionPolicy();
                Region region2 = region;
                synchronized (region2) {
                    EvictionAlgorithm algo = policy.getEvictionAlgorithm();
                    try {
                        algo.process(region);
                    }
                    catch (EvictionException e) {
                        this.log.error((Object)("run(): error processing eviction with exception: " + e.toString() + " will reset the eviction queue list."));
                        region.resetEvictionQueues();
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

