/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;

public class FIFOQueue
implements EvictionQueue {
    private Map nodeMap = new LinkedHashMap();

    FIFOQueue() {
    }

    public NodeEntry getFirstNodeEntry() {
        if (this.nodeMap.size() > 0) {
            return (NodeEntry)this.nodeMap.values().iterator().next();
        }
        return null;
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.getNodeEntry(fqn.toString());
    }

    public NodeEntry getNodeEntry(String fqn) {
        return (NodeEntry)this.nodeMap.get(fqn);
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    public void removeNodeEntry(NodeEntry entry) {
        this.nodeMap.remove(entry.getFqn().toString());
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            this.nodeMap.put(entry.getFqn().toString(), entry);
        }
    }

    public int size() {
        return this.nodeMap.size();
    }

    public void clear() {
        this.nodeMap.clear();
    }

    final Iterator iterate() {
        return this.nodeMap.entrySet().iterator();
    }
}

