/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionListEntry;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.EvictionQueueList;
import org.jboss.cache.eviction.NodeEntry;

public class MRUQueue
implements EvictionQueue {
    Map nodeMap = new HashMap();
    EvictionQueueList list = new EvictionQueueList();

    MRUQueue() {
    }

    void moveToTopOfStack(Fqn fqn) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.get(fqn.toString());
        if (le != null) {
            this.list.remove((EvictionListEntry)this.nodeMap.remove(fqn.toString()));
            this.list.addToTop(le);
            this.nodeMap.put(le.node.getFqn().toString(), le);
        }
    }

    public NodeEntry getFirstNodeEntry() {
        try {
            return this.list.getFirst().node;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.getNodeEntry(fqn.toString());
    }

    public NodeEntry getNodeEntry(String fqn) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.get(fqn);
        if (le != null) {
            return le.node;
        }
        return null;
    }

    public boolean containsNodeEntry(NodeEntry entry) {
        return this.nodeMap.containsKey(entry.getFqn().toString());
    }

    public void removeNodeEntry(NodeEntry entry) {
        EvictionListEntry le = (EvictionListEntry)this.nodeMap.remove(entry.getFqn().toString());
        if (le != null) {
            this.list.remove(le);
        }
    }

    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            EvictionListEntry le = new EvictionListEntry(entry);
            this.list.addToBottom(le);
            this.nodeMap.put(entry.getFqn().toString(), le);
        }
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.nodeMap.clear();
        this.list.clear();
    }
}

