/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractTreeCacheListener;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.Address;
import org.jgroups.View;

public class SharedStoreCacheLoader
extends AbstractTreeCacheListener
implements CacheLoader {
    CacheLoader loader = null;
    Address local_addr = null;
    boolean active = true;
    Log log = LogFactory.getLog(this.getClass());
    TreeCache cache = null;

    public SharedStoreCacheLoader(CacheLoader loader, Address local_addr, boolean coordinator) {
        this.loader = loader;
        this.local_addr = local_addr;
        this.active = coordinator;
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeRemoved(Fqn fqn) {
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeEvicted(Fqn fqn) {
    }

    public void nodeModified(Fqn fqn) {
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(View new_view) {
        boolean tmp = this.active;
        if (new_view != null && this.local_addr != null) {
            Vector mbrs = new_view.getMembers();
            tmp = mbrs != null && mbrs.size() > 0 && this.local_addr.equals(mbrs.firstElement());
        }
        if (this.active != tmp) {
            this.active = tmp;
            this.log.info((Object)("changed mode: active=" + this.active));
        }
    }

    public void setConfig(Properties props) {
        this.loader.setConfig(props);
    }

    public void setCache(TreeCache c) {
        this.cache = c;
        this.loader.setCache(c);
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        return this.loader.getChildrenNames(fqn);
    }

    public Map get(Fqn name) throws Exception {
        return this.loader.get(name);
    }

    public boolean exists(Fqn name) throws Exception {
        return this.loader.exists(name);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.active) {
            return this.loader.put(name, key, value);
        }
        return null;
    }

    public void put(Fqn name, Map attributes) throws Exception {
        if (this.active) {
            this.loader.put(name, attributes);
        }
    }

    public void put(List modifications) throws Exception {
        if (this.active) {
            this.loader.put(modifications);
        }
    }

    public Object remove(Fqn name, Object key) throws Exception {
        if (this.active) {
            return this.loader.remove(name, key);
        }
        return null;
    }

    public void remove(Fqn name) throws Exception {
        if (this.active) {
            this.loader.remove(name);
        }
    }

    public void removeData(Fqn name) throws Exception {
        if (this.active) {
            this.loader.removeData(name);
        }
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        if (this.active) {
            this.loader.prepare(tx, modifications, one_phase);
        }
    }

    public void commit(Object tx) throws Exception {
        if (this.active) {
            this.loader.commit(tx);
        }
    }

    public void rollback(Object tx) {
        if (this.active) {
            this.loader.rollback(tx);
        }
    }

    public byte[] loadEntireState() throws Exception {
        return this.loader.loadEntireState();
    }

    public void storeEntireState(byte[] state) throws Exception {
        if (this.active) {
            this.loader.storeEntireState(state);
        }
    }

    public void create() throws Exception {
        this.loader.create();
    }

    public void start() throws Exception {
        this.loader.start();
    }

    public void stop() {
        this.loader.stop();
    }

    public void destroy() {
        this.loader.destroy();
    }
}

