/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.lock.BelasLockStrategy;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyNone;
import org.jboss.cache.lock.LockStrategyReadCommitted;
import org.jboss.cache.lock.LockStrategyReadUncommitted;
import org.jboss.cache.lock.LockStrategyRepeatableRead;
import org.jboss.cache.lock.LockStrategySerializable;

public class LockStrategyFactory {
    private static IsolationLevel lockingLevel_ = IsolationLevel.REPEATABLE_READ;

    protected LockStrategyFactory() {
    }

    public static LockStrategy getLockStrategy() {
        return LockStrategyFactory.getLockStrategy(lockingLevel_);
    }

    public static LockStrategy getLockStrategy(IsolationLevel lockingLevel) {
        if (lockingLevel == null || lockingLevel == IsolationLevel.NONE) {
            return new LockStrategyNone();
        }
        if (lockingLevel == IsolationLevel.REPEATABLE_READ) {
            return new LockStrategyRepeatableRead();
        }
        if (lockingLevel == IsolationLevel.SERIALIZABLE) {
            return new LockStrategySerializable();
        }
        if (lockingLevel == IsolationLevel.READ_COMMITTED) {
            return new LockStrategyReadCommitted();
        }
        if (lockingLevel == IsolationLevel.READ_UNCOMMITTED) {
            return new LockStrategyReadUncommitted();
        }
        if (lockingLevel == IsolationLevel.BELA) {
            return new BelasLockStrategy();
        }
        throw new RuntimeException("getLockStrategy: LockStrategy selection not recognized. selection: " + lockingLevel);
    }

    public static void setIsolationLevel(IsolationLevel level) {
        lockingLevel_ = level;
    }
}

