package ch4.demoManyToMany;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

@Entity
public class Coach {
	@Id
	@GeneratedValue
	private int id;
	
	
	//@ManyToMany
	@OneToMany
	@MapKey(columns = {
			@Column(name="startDate"),
			@Column(name="label")}
	)
	private Map<Season,Team> teams = new HashMap<Season,Team>();

	@CollectionOfElements
	private Set<String> nicknames = new HashSet<String>();
	
	private String name;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Map<Season, Team> getTeams() {
		return teams;
	}

	public void setTeams(Map<Season, Team> teams) {
		this.teams = teams;
	}





}
