package ch4.demoManyToMany;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Transient;

@Entity
public class Team {
	@Id
	@GeneratedValue
	private int id;
	
	@OneToMany(mappedBy="team")
	private Set<Player> players = new HashSet<Player>();
	
	@OneToMany(mappedBy="homeTeam")
	@MapKey(name="gameDate")
	private Map<Date,Game> homeGames = new HashMap<Date,Game>();
	
	@OneToMany(mappedBy="awayTeam")
	@MapKey(name="gameDate")
	private Map<Date,Game> awayGames = new HashMap<Date,Game>();
	
	@Transient
	private int nbLostGames;

	private String name;

	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Set<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Set<Player> players) {
		this.players = players;
	}

	public Map<Date, Game> getHomeGames() {
		return homeGames;
	}

	public void setHomeGames(Map<Date, Game> homeGames) {
		this.homeGames = homeGames;
	}

	public Map<Date, Game> getAwayGames() {
		return awayGames;
	}

	public void setAwayGames(Map<Date, Game> awayGames) {
		this.awayGames = awayGames;
	}

	public int getNbLostGames() {
		return nbLostGames;
	}

	public void setNbLostGames(int nbLostGames) {
		this.nbLostGames = nbLostGames;
	}

}
