package ch4.demoNaire;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKeyManyToMany;

@Entity
@Table(catalog="toto")
public class Coach {
	@Id
	@GeneratedValue
	private int id;
	
	@CollectionOfElements
	@MapKeyManyToMany
	private Map<Season,CoachTeam> coachTeams = new HashMap<Season,CoachTeam>();
	
	private String name;

	public int getId() {
		return id;
	}

	public void createCoachTeam(Season season, Person director, Team team){
		CoachTeam coachTeam = new CoachTeam();
		coachTeam.setCoach(this);
		coachTeam.setDirector(director);
		coachTeam.setTeam(team);
		this.getCoachTeams().put(season, coachTeam);
	}
	
	public void setId(int id) {
		this.id = id;
	}



	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Map<Season, CoachTeam> getCoachTeams() {
		return coachTeams;
	}

	public void setCoachTeams(Map<Season, CoachTeam> coachTeams) {
		this.coachTeams = coachTeams;
	}

}
