package ch5;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Transient;

@Entity
@NamedQuery(name="myNamedQuery",
		query="Select player from Player player where player.name in(:name1)")
@SqlResultSetMappings({
		@SqlResultSetMapping(name="PlayerResults",
				entities=@EntityResult(entityClass=Player.class)
		),
		@SqlResultSetMapping(name="PlayerWithSchoolResults",
				entities={
					@EntityResult(entityClass=Player.class),
					@EntityResult(entityClass=School.class, fields={
							@FieldResult(name="id", column="school_id"),
							@FieldResult(name="name", column="school_name")
					})
		})
})
public class Player {
	@Id
	@GeneratedValue(
			strategy=GenerationType.AUTO)
	private int id;
	private float height;
	private String name;
	
	@OneToMany(cascade = CascadeType.PERSIST,fetch=FetchType.LAZY)
	@org.hibernate.annotations.Fetch(
			org.hibernate.annotations.FetchMode.SUBSELECT
	)
	//@org.hibernate.annotations.BatchSize(size=3)
	private Set<Characteristic> characteristics = new HashSet<Characteristic>();
	
	@ManyToOne(cascade=CascadeType.PERSIST,fetch=FetchType.LAZY)
	private School school;
	
	// jouer avec transient ou manytoone selon les tests
	@ManyToOne(fetch=FetchType.LAZY)
	//@org.hibernate.annotations.LazyToOne(org.hibernate.annotations.LazyToOneOption.NO_PROXY)
	//@Transient
	private Team team;

	public Player(String name){
		this.name = name;
	}
	
	public Player(){}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Team getTeam() {
		return team;
	}

	public void setTeam(Team team) {
		this.team = team;
	}

	public Set<Characteristic> getCharacteristics() {
		return characteristics;
	}

	public void setCharacteristics(Set<Characteristic> characteristics) {
		this.characteristics = characteristics;
	}

	public School getSchool() {
		return school;
	}

	public void setSchool(School school) {
		this.school = school;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}
	
	
	
}
