package ch5;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;

import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Type;

@Entity
@TableGenerator(name="ids_generator", table="IDS")
public class Team {
	@Id
	@GeneratedValue(
			strategy=GenerationType.AUTO)
	@Column(name="TEAM_ID")
	private int id;
	
	// changer le type de la collection selon les diffrents tests.
	@OneToMany(cascade = CascadeType.PERSIST)
	@CollectionId(
        columns = @Column(name="COLLECTION_ID"), 
        type=@Type(type="long"),
        generator="ids_generator"
    )
	private Set<Player> players = new HashSet<Player>();
	
	@OneToMany(mappedBy="homeTeam")
	@MapKey(name="gameDate")
	private Map<Date,Game> homeGames = new HashMap<Date,Game>();
	
	@OneToMany(mappedBy="awayTeam")
	@MapKey(name="gameDate")
	private Map<Date,Game> awayGames = new HashMap<Date,Game>();
	
	@Transient
	//@OneToOne
	private Coach coach;
	
	@Transient
	private int nbLostGames;

	private String name;

	public Team(String name){
		this.name = name;
	}
	
	public Team(){}
	
	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Set<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Set<Player> players) {
		this.players = players;
	}

	public Map<Date, Game> getHomeGames() {
		return homeGames;
	}

	public void setHomeGames(Map<Date, Game> homeGames) {
		this.homeGames = homeGames;
	}

	public Map<Date, Game> getAwayGames() {
		return awayGames;
	}

	public void setAwayGames(Map<Date, Game> awayGames) {
		this.awayGames = awayGames;
	}

	public Coach getCoach() {
		return coach;
	}

	public void setCoach(Coach coach) {
		this.coach = coach;
	}

	public int getNbLostGames() {
		return nbLostGames;
	}

	public void setNbLostGames(int nbLostGames) {
		this.nbLostGames = nbLostGames;
	}

}
