package ch6;

import java.util.ArrayList;
import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true,dynamicInsert=true)
public class Team {
	@Id
	@GeneratedValue(
			strategy=GenerationType.AUTO)
	private int id;
	
	@Version
	private int version;
	
	@OneToMany(cascade={
			CascadeType.PERSIST,
			CascadeType.REMOVE
	})
	// nous utilisons @JoinColumn car nous n'avons pas de 
	// table d'association mais juste une cl trangre 
	// de la table PLAYER vers la table TEAM 
	@JoinColumn(name="Team_ID")
	@org.hibernate.annotations.Cascade({
		org.hibernate.annotations.CascadeType.DELETE_ORPHAN,
		org.hibernate.annotations.CascadeType.REPLICATE
	})
	private Collection<Player> players = new ArrayList<Player>();
	
	@OneToOne(cascade={
			CascadeType.PERSIST,
			CascadeType.REMOVE
	})
	private Coach coach;
	
	private String name;

	public Team(String name){
		this.name = name;
	}
	
	public Team(){}
	
	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Collection<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Collection<Player> players) {
		this.players = players;
	}


	public Coach getCoach() {
		return coach;
	}

	public void setCoach(Coach coach) {
		this.coach = coach;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}



}
