package ch7.model;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class Game {
	@Id
	@GeneratedValue(
			strategy=GenerationType.AUTO)
	private int id;
	
	@Temporal(TemporalType.DATE)
	private Date gameDate;
	
	@ManyToOne
	@JoinColumn(name="HOME_TEAM_ID")
	private Team homeTeam;
	
	@ManyToOne
	@JoinColumn(name="AWAY_TEAM_ID")
	private Team awayTeam;
	
	@ManyToOne
	@JoinColumn(name="MVP_ID")
	private Player mostValuablePlayer;

	private int homeTeamScore;
	private int awayTeamScore;
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Date getGameDate() {
		return gameDate;
	}

	public void setGameDate(Date gameDate) {
		this.gameDate = gameDate;
	}

	public Team getHomeTeam() {
		return homeTeam;
	}

	public void setHomeTeam(Team homeTeam) {
		this.homeTeam = homeTeam;
	}

	public Team getAwayTeam() {
		return awayTeam;
	}

	public void setAwayTeam(Team awayTeam) {
		this.awayTeam = awayTeam;
	}

	public Player getMostValuablePlayer() {
		return mostValuablePlayer;
	}

	public void setMostValuablePlayer(Player mostValuablePlayer) {
		this.mostValuablePlayer = mostValuablePlayer;
	}

	public int getHomeTeamScore() {
		return homeTeamScore;
	}

	public void setHomeTeamScore(int homeTeamScore) {
		this.homeTeamScore = homeTeamScore;
	}

	public int getAwayTeamScore() {
		return awayTeamScore;
	}

	public void setAwayTeamScore(int awayTeamScore) {
		this.awayTeamScore = awayTeamScore;
	}
	
}
