package ch7.service;

import java.util.List;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import ch7.model.Coach;
import ch7.model.Player;
import ch7.model.Team;

@Stateless
public class ConversationDemoDetached implements ConversationDemo {

	@PersistenceContext(unitName = "eyrollesEntityManager")
	private EntityManager em;
	
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public List<Team> getAllTeams() {
		List<Team> result = null;
        result = em.createQuery("select team from Team team").getResultList();
        return result;
	}

	public Team getTeam(Integer id) {
		StringBuffer queryString = new StringBuffer();
		queryString.append("select team from Team team ")
			.append("left join fetch team.coach ")
			.append("left join fetch team.players ")
			.append("where team.id = :theId");
		Query q = em.createQuery(queryString.toString());
		q.setParameter("theId", id);
		Team result = (Team)q.getSingleResult();
        return result;
	}

	public List<Coach> getFreeCoachs() {
		List<Coach> results = em
			.createQuery("from Coach c where c.team is null")
			.getResultList();
		return results;
	}

	public List<Player> getFreePlayers() {
		List<Player> results = em
		.createQuery("from Player p where p.team is null")
		.getResultList();
	return results;
	}

	public Team mergeTeam(Team team){
		return em.merge(team);
	}

	public void validateModification(Team team) {
		em.merge(team);		
	}

	public void validateModification() {
		// impossible avec detached
		
	}
	
}
