package ch7.service;

import java.util.List;

import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceProperty;

import ch7.model.Coach;
import ch7.model.Player;
import ch7.model.Team;

@Stateful
@TransactionAttribute(TransactionAttributeType.NOT_SUPPORTED)
public class ConversationDemoExtended implements ConversationDemo {

	@PersistenceContext(
			unitName = "eyrollesEntityManager",
			type = PersistenceContextType.EXTENDED,
			properties = @PersistenceProperty(
					name="org.hibernate.flushMode",
					value="MANUAL")
	)
	private EntityManager em;
	
	
	public List<Team> getAllTeams() {
		List<Team> result = null;
		result = em.createQuery("select team from Team team").getResultList();
        return result;
	}

	public Team getTeam(Integer id) {
		Team result = em.find(Team.class,id);
		return result;
	}


	public List<Coach> getFreeCoachs() {
		List<Coach> results = em
			.createQuery("from Coach c where c.team is null")
			.getResultList();
		return results;
	}

	public List<Player> getFreePlayers() {
		List<Player> results = em
		.createQuery("from Player p where p.team is null")
		.getResultList();
	return results;
	}

	@Remove
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public void validateModification() {
		
	}
	
	@Remove
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public void validateModification(Team team) {
		//em.flush();		
	}
	
	public Team mergeTeam(Team team){
		return em.merge(team);
	}

}
