package ch7.service;

import java.util.List;

import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;

import org.hibernate.Session;
import org.hibernate.SessionFactory;

import ch7.model.Team;

@Stateless
@TransactionManagement(TransactionManagementType.BEAN)
public class TeamManagerBeanBmt implements TeamManager {

	@Resource 
	UserTransaction ut;
	
	@PersistenceContext(unitName = "eyrollesEntityManager")
	private EntityManager em;
	
	
	public List<Team> getAllTeams() {
		List<Team> result = null;
		try{
    		ut.begin();
	        result = em.createQuery("select team from Team team").getResultList();
			ut.commit();			
		} 
		catch (Exception ex) {
			try {
				ut.rollback();
			} 
			catch (Exception rbEx) {
				rbEx.printStackTrace();
			}
			ex.printStackTrace();
		}
        return result;
	}

	public Team getTeam(Integer id) {
		Team result = null;
		try{
    		ut.begin();
	        result = em.find(Team.class,id);
			ut.commit();
		} 
		catch (Exception ex) {
			try {
				ut.rollback();
			} 
			catch (Exception rbEx) {
				rbEx.printStackTrace();
			}
			ex.printStackTrace();
		}
        return result;
	}
	
	@TransactionAttribute(TransactionAttributeType.MANDATORY) 
	public Team merge(Team team) {
		return em.merge(team); 
	}

}
