package ch7.service;

import java.util.List;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import ch7.model.Team;

@Stateless
public class TeamManagerBeanCmt implements TeamManager {

	@PersistenceContext(unitName = "eyrollesEntityManager")
	private EntityManager em;
	
		
	@TransactionAttribute(TransactionAttributeType.REQUIRED)
	public List<Team> getAllTeams() {
		List<Team> result = null;
        result = em.createQuery("select team from Team team").getResultList();
        return result;
	}

	public Team getTeam(Integer id) {
		Team result = em.find(Team.class,id);
        return result;
	}

	public Team merge(Team team) {
		return em.merge(team); 
	}

}
