package ch8.demoCompositeId;

import java.io.Serializable;

import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;

public class IdTeam implements Serializable {
	private String name;
	private int year;
	
	@ManyToOne
	private Country country;
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public int getYear() {
		return year;
	}
	public void setYear(int year) {
		this.year = year;
	}
	public Country getCountry() {
		return country;
	}
	public void setCountry(Country country) {
		this.country = country;
	}
	
	  // getters & setters
	  public boolean equals(Object o) {
	    if (this == o) return true;
	    if (o == null) return false;
	    if (!(o instanceof IdTeam)) return false;
	    final IdTeam teamId = (IdTeam) o;
	    if (year == teamId.getYear())
	      return false;
	    if (!name.equals(teamId.getName()))
	      return false;
	    return true;
	  }
	  public int hashCode() {
	    return name.hashCode();
	  }
	

}
